/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ReflectionHelper {
    private static final Map<Class<? extends Annotation>, Map<AnnotatedElement, Annotation>> cache = new HashMap<Class<? extends Annotation>, Map<AnnotatedElement, Annotation>>();

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass, AnnotatedElement element) {
        Object annotation;
        Map<AnnotatedElement, Annotation> cacheMap = cache.get(annotationClass);
        if (cacheMap == null) {
            cacheMap = new HashMap<AnnotatedElement, Annotation>();
            cache.put(annotationClass, cacheMap);
        }
        if (cacheMap.containsKey(element)) {
            annotation = cacheMap.get(element);
        } else {
            annotation = element.getAnnotation(annotationClass);
            if (annotation == null && element instanceof Method) {
                annotation = ReflectionHelper.getOverriddenAnnotation(annotationClass, (Method)element);
            }
            cacheMap.put(element, (Annotation)annotation);
        }
        return annotation;
    }

    private static <A extends Annotation> A getOverriddenAnnotation(Class<A> annotationClass, Method method) {
        A result = null;
        Class<?> methodClass = method.getDeclaringClass();
        String name = method.getName();
        Class<?>[] params = method.getParameterTypes();
        Class<?> superclass = methodClass.getSuperclass();
        if (superclass != null) {
            result = ReflectionHelper.getOverriddenAnnotationFrom(annotationClass, superclass, name, params);
        }
        if (result == null) {
            Class<?> intf;
            Class<?>[] classArray = methodClass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (result = (A)ReflectionHelper.getOverriddenAnnotationFrom(annotationClass, intf = classArray[i], name, params)) == null; ++i) {
            }
        }
        return result;
    }

    private static <A extends Annotation> A getOverriddenAnnotationFrom(Class<A> annotationClass, Class<?> searchClass, String name, Class<?>[] params) {
        A result = null;
        try {
            Method method = searchClass.getMethod(name, params);
            result = method.getAnnotation(annotationClass);
            if (result == null) {
                result = ReflectionHelper.getOverriddenAnnotation(annotationClass, method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return result;
    }

    public void setField(Object o, String fieldName, Object newValue) {
        if (o == null) {
            throw new IllegalArgumentException("No object to set on provided");
        }
        Field field = this.findField(o, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(o.getClass() + " does not have a field " + fieldName);
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(o, newValue);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to set " + newValue + " for " + fieldName, e);
        }
    }

    public Object getField(Object o, String fieldName) {
        if (o == null) {
            throw new IllegalArgumentException("No object to get from provided");
        }
        Field field = this.findField(o, fieldName);
        if (field == null) {
            throw new IllegalArgumentException(o.getClass() + " does not have a field " + fieldName);
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return field.get(o);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to get " + fieldName, e);
        }
    }

    private Field findField(Object o, String fieldName) {
        Class<?> aClass = o.getClass();
        Field result = null;
        while (result == null && !Object.class.equals(aClass)) {
            try {
                result = aClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                aClass = aClass.getSuperclass();
            }
        }
        return result;
    }
}

