/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class SecretMasker {
    public Map<String, Object> replaceSecrets(Collection<String> keysToMask, Map<String, ?> originalMap) {
        boolean replaced = false;
        LinkedHashMap<String, Object> newMap = null;
        try {
            newMap = new LinkedHashMap<String, Object>(originalMap);
            replaced = this.replaceDirectSecrets(keysToMask, newMap);
            if (this.replaceNestedSecrets(keysToMask, newMap)) {
                replaced = true;
            }
        }
        catch (RuntimeException e) {
            System.err.println("Unable to remove secrets from: " + originalMap);
        }
        return replaced ? newMap : originalMap;
    }

    protected boolean replaceDirectSecrets(Iterable<String> keysToMask, Map<String, Object> newMap) {
        AtomicBoolean replaced = new AtomicBoolean(false);
        keysToMask.forEach(s -> {
            if (newMap.containsKey(s)) {
                newMap.replace((String)s, "*****");
                replaced.set(true);
            }
        });
        return replaced.get();
    }

    protected boolean replaceNestedSecrets(Collection<String> keysToMask, Map<String, Object> newMap) {
        AtomicBoolean replaced = new AtomicBoolean(false);
        newMap.entrySet().forEach(e -> {
            Map<String, Object> safeValue;
            Object currentValue = e.getValue();
            if (currentValue instanceof Map && currentValue != (safeValue = this.replaceSecrets(keysToMask, (Map)currentValue))) {
                newMap.replace((String)e.getKey(), safeValue);
                replaced.set(true);
            }
        });
        return replaced.get();
    }
}

