/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nl.hsac.fitnesse.fixture.util.Formatter;

public class XMLFormatter
implements Formatter {
    public static final Pattern DECL_PATTERN = Pattern.compile("^<\\?xml\\s.*?\\?>", 32);
    public static final Pattern ELEMENT_CONTENT_PATTERN = Pattern.compile(">\\s*(.*?)\\s*<", 32);
    private boolean trimElements = true;

    @Override
    public String format(String xml) {
        try {
            boolean keepDeclaration = DECL_PATTERN.matcher(xml).find();
            if (this.trimElements) {
                xml = XMLFormatter.trimElements(xml);
            }
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", keepDeclaration ? "no" : "yes");
            transformer.transform(xmlInput, xmlOutput);
            return xmlOutput.getWriter().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean areElementsTrimmed() {
        return this.trimElements;
    }

    public void setTrimElements(boolean trimElements) {
        this.trimElements = trimElements;
    }

    public static String trim(String xml) {
        String content = XMLFormatter.removeDeclaration(xml);
        return XMLFormatter.trimElements(content);
    }

    public static String removeDeclaration(String xml) {
        Matcher matcher = DECL_PATTERN.matcher(xml);
        return matcher.replaceFirst("");
    }

    public static String trimElements(String xml) {
        String result = xml.trim();
        Matcher matcher = ELEMENT_CONTENT_PATTERN.matcher(result);
        return matcher.replaceAll(">$1<");
    }
}

