/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLValidator {
    private static final XMLInputFactory XML_INPUT_FACTORY = XMLInputFactory.newInstance();

    public boolean checkWelformed(String xml) {
        boolean result;
        try {
            this.isWelformed(xml);
            result = true;
        }
        catch (RuntimeException e) {
            result = false;
        }
        return result;
    }

    public void isWelformed(String xml) {
        StringReader reader = new StringReader(xml);
        XMLStreamReader r = null;
        try {
            r = XML_INPUT_FACTORY.createXMLStreamReader(reader);
            while (r.hasNext()) {
                r.next();
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
            reader.close();
        }
    }

    public boolean validateAgainst(String xmlContent, String xsdContent) {
        try {
            SAXSource xsd = new SAXSource(new InputSource(new StringReader(xsdContent)));
            SAXSource xml = new SAXSource(new InputSource(new StringReader(xmlContent)));
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(xsd);
            Validator validator = schema.newValidator();
            validator.validate(xml);
            return true;
        }
        catch (SAXException e) {
            throw new SlimFixtureException(false, "XML Validation failed: " + e.getMessage());
        }
        catch (IOException e) {
            throw new SlimFixtureException(e);
        }
    }
}

