/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.util.ArrayList;
import java.util.List;

public class XPathCheckResult {
    private String result = "OK";
    private List<Mismatch> mismatches = new ArrayList<Mismatch>();
    private String mismatchDetail;

    public String toString() {
        String str = this.result;
        String mismatchDetails = this.getMismatchDetail();
        if (mismatchDetails != null) {
            str = mismatchDetails;
        }
        return str;
    }

    public static XPathCheckResult parse(String value) {
        XPathCheckResult parsed = new XPathCheckResult();
        parsed.result = value;
        return parsed;
    }

    public void addMisMatch(String name, String expected, String actual) {
        this.result = "NOK";
        Mismatch mismatch = new Mismatch();
        mismatch.name = name;
        mismatch.expected = expected;
        mismatch.actual = actual;
        this.mismatches.add(mismatch);
    }

    public String getMismatchDetail() {
        String result = this.mismatchDetail;
        if (this.hasMismatch()) {
            StringBuilder builder = new StringBuilder("@@NO_ESCAPE@@NOK:\n<ul>\n");
            for (Mismatch mismatch : this.mismatches) {
                builder.append(" <li>");
                builder.append(mismatch.toString());
                builder.append("</li>\n");
            }
            builder.append("</ul>");
            result = builder.toString();
        }
        return result;
    }

    public boolean hasMismatch() {
        return !this.mismatches.isEmpty();
    }

    public void setMismatchDetail(String aMismatchDetail) {
        this.result = "NOK";
        this.mismatchDetail = aMismatchDetail;
    }

    public boolean equals(Object anObject) {
        if (anObject == this) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        if (anObject instanceof XPathCheckResult) {
            return String.valueOf(((XPathCheckResult)anObject).getResult()).equalsIgnoreCase(this.result);
        }
        return false;
    }

    public int hashCode() {
        int ret = 0;
        if (this.result != null) {
            ret = this.result.hashCode();
        }
        return ret;
    }

    public String getResult() {
        return this.result;
    }

    private class Mismatch {
        public String name;
        public String expected;
        public String actual;

        private Mismatch() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name);
            builder.append(": ");
            builder.append(this.expected);
            builder.append(" <> ");
            builder.append(this.actual);
            return builder.toString();
        }
    }
}

