/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import fit.exception.FitFailureException;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.util.HttpResponse;
import nl.hsac.fitnesse.fixture.util.XPathCheckResult;
import nl.hsac.fitnesse.fixture.util.XPathHelper;

public class XmlHttpResponse
extends HttpResponse {
    public static final String CONTENT_TYPE_XML_TEXT_UTF8 = "text/xml; charset=UTF-8";
    private NamespaceContext namespaceContext;
    private XPathHelper xPathHelper;

    @Override
    public void validResponse() {
        super.validResponse();
        String response = this.getResponse();
        if (response != null) {
            boolean ableToXPath = false;
            try {
                String faultCode = this.getRawXPath(response, "/env:Envelope/env:Body/env:Fault/faultcode", new Object[0]);
                ableToXPath = true;
                if (faultCode != null) {
                    Environment.handleErrorResponse("SOAP fault received: ", response);
                }
            }
            catch (FitFailureException e) {
                if (ableToXPath) {
                    throw e;
                }
                Environment.handleErrorResponse("Unable to check for SOAP fault, is the result XML? Response was:", response);
            }
        }
    }

    public String getXPath(String xPathExpr, Object ... params) {
        this.validResponse();
        return this.getRawXPath(xPathExpr, params);
    }

    public String getRawXPath(String xPathExpr, Object ... params) {
        return this.getRawXPath(this.getResponse(), xPathExpr, params);
    }

    protected String getRawXPath(String soapResponse, String xPathExpr, Object ... params) {
        String expr = String.format(xPathExpr, params);
        String xPathValue = this.getXPathHelper().getXPath(this.namespaceContext, soapResponse, expr);
        if ("".equals(xPathValue)) {
            xPathValue = null;
        }
        return xPathValue;
    }

    public Double getXPathDouble(String xPathExpr, Object ... params) {
        Double result = null;
        String xPathValue = this.getXPath(xPathExpr, params);
        if (xPathValue != null) {
            result = Double.valueOf(xPathValue);
        }
        return result;
    }

    public Integer getXPathInt(String xPathExpr, Object ... params) {
        Integer result = null;
        String xPathValue = this.getXPath(xPathExpr, params);
        if (xPathValue != null) {
            result = Integer.valueOf(xPathValue);
        }
        return result;
    }

    public Double getXPathAmount(String xPathExpr, Object ... params) {
        Double result = this.getXPathDouble(xPathExpr, params);
        if (result != null) {
            result = (double)Math.round(result * 100.0) / 100.0;
        }
        return result;
    }

    public String getXPathDate(String xPathExpr, Object ... params) {
        String result = this.getXPath(xPathExpr, params);
        if (result != null) {
            result = result.substring(0, 10);
        }
        return result;
    }

    public XPathCheckResult checkXPaths(Map<String, Object> values, Map<String, String> expressionsToCheck) {
        XPathCheckResult result;
        String content = this.getResponse();
        if (content == null) {
            result = new XPathCheckResult();
            result.setMismatchDetail("NOK: no response available.");
        } else {
            this.validResponse();
            result = this.checkRawXPaths(content, expressionsToCheck, values);
        }
        return result;
    }

    protected XPathCheckResult checkRawXPaths(String content, Map<String, String> expressionsToCheck, Map<String, Object> values) {
        XPathCheckResult result = new XPathCheckResult();
        for (Map.Entry<String, String> exprEntry : expressionsToCheck.entrySet()) {
            String xpathValue;
            String xpath = exprEntry.getKey();
            String keyName = exprEntry.getValue();
            Object value = null;
            String valueStr = null;
            value = keyName.contains(".") && !values.containsKey(keyName) ? this.getNestedValue(values, keyName) : values.get(keyName);
            valueStr = String.valueOf(value);
            if (valueStr.equals(xpathValue = String.valueOf(this.getRawXPath(content, xpath, new Object[0])).trim()) || this.equalsDates(valueStr, xpathValue) || this.equalsAmounts(valueStr, xpathValue) || "".equals(valueStr) && "null".equals(xpathValue)) continue;
            result.addMisMatch(keyName, valueStr, xpathValue);
        }
        return result;
    }

    private Object getNestedValue(Map<String, Object> values, String keyName) {
        String[] keyPath = keyName.split("\\.");
        String parentKey = keyPath[0];
        String valueKey = keyPath[1];
        Map firstValue = (Map)values.get(parentKey);
        return firstValue.get(valueKey);
    }

    private boolean equalsDates(String aValue, String aXpathValue) {
        String timeZone;
        boolean result = false;
        if (aValue.length() == 10 && aXpathValue.startsWith(aValue) && (timeZone = aXpathValue.substring(10)).matches("[+-]\\d\\d:\\d\\d")) {
            result = true;
        }
        return result;
    }

    private boolean equalsAmounts(String aValue, String aXpathValue) {
        boolean result = false;
        try {
            Double value = Double.parseDouble(aValue);
            Double xpath = Double.parseDouble(aXpathValue);
            result = value.equals(xpath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getXsiTypeValue(String type) {
        return type;
    }

    public List<String> getAllXPath(String xPathExpr, Object ... params) {
        this.validResponse();
        return this.getRawAllXPath(this.response, xPathExpr, params);
    }

    protected List<String> getRawAllXPath(String soapResponse, String xPathExpr, Object ... params) {
        String expr = String.format(xPathExpr, params);
        return this.getXPathHelper().getAllXPath(this.namespaceContext, soapResponse, expr);
    }

    public void setNamespaceContext(NamespaceContext aNamespaceContext) {
        this.namespaceContext = aNamespaceContext;
    }

    public void setXPathHelper(XPathHelper xPathHelper) {
        this.xPathHelper = xPathHelper;
    }

    public XPathHelper getXPathHelper() {
        return this.xPathHelper;
    }
}

