/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class ZipHelper {
    public File createZip(String targetName, String ... sourceFiles) throws IOException {
        File target = new File(targetName);
        this.ensureFileDoesNotYetExist(target);
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(target));){
            for (String srcFile : sourceFiles) {
                File fileToZip = new File(srcFile);
                this.addEntries(fileToZip, fileToZip.getName(), zipOut);
            }
        }
        return target;
    }

    protected List<ZipEntry> addEntries(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        List<ZipEntry> result;
        if (fileToZip.isHidden()) {
            return Collections.emptyList();
        }
        if (fileToZip.isDirectory()) {
            result = this.addDirectory(zipOut, fileToZip, fileName);
        } else {
            ZipEntry entry = this.addFile(zipOut, fileToZip, fileName);
            result = Collections.singletonList(entry);
        }
        return result;
    }

    private List<ZipEntry> addDirectory(ZipOutputStream zipOut, File fileToZip, String directoryName) throws IOException {
        File[] children;
        ArrayList<ZipEntry> result = new ArrayList<ZipEntry>();
        if (!directoryName.endsWith("/")) {
            directoryName = directoryName + "/";
        }
        ZipEntry dirEntry = new ZipEntry(directoryName);
        zipOut.putNextEntry(dirEntry);
        zipOut.closeEntry();
        result.add(dirEntry);
        for (File childFile : children = fileToZip.listFiles()) {
            List<ZipEntry> childEntries = this.addEntries(childFile, directoryName + childFile.getName(), zipOut);
            result.addAll(childEntries);
        }
        return result;
    }

    private ZipEntry addFile(ZipOutputStream zipOut, File fileToZip, String fileName) throws IOException {
        try (FileInputStream fis = new FileInputStream(fileToZip);){
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOut.putNextEntry(zipEntry);
            IOUtils.copy((InputStream)fis, (OutputStream)zipOut);
            ZipEntry zipEntry2 = zipEntry;
            return zipEntry2;
        }
    }

    public List<File> unzip(String zipFile, String destination) throws IOException {
        File destDir = new File(destination);
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new IOException("Unable to create: " + destDir.getAbsolutePath());
        }
        List<File> allEntries = this.visitZipEntries(zipFile, (zf, zipEntry) -> this.unzipEntry((ZipFile)zf, (ZipEntry)zipEntry, destDir));
        return allEntries.stream().filter(f -> !f.isDirectory()).collect(Collectors.toList());
    }

    public List<ZipEntry> getEntries(String zipFile) throws IOException {
        return this.visitZipEntries(zipFile, (zf, entry) -> entry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> List<T> visitZipEntries(String zipFile, BiFunction<ZipFile, ZipEntry, T> consumer) throws IOException {
        try (ZipFile zFile = new ZipFile(zipFile);){
            List list = ((Stream)zFile.stream().parallel()).map(e -> consumer.apply(zFile, (ZipEntry)e)).collect(Collectors.toList());
            return list;
        }
        catch (RuntimeIOException e2) {
            throw e2.getCause();
        }
    }

    protected File unzipEntry(ZipFile zipFile, ZipEntry entry, File targetDir) {
        try {
            File targetFile = this.preventZipSlip(targetDir, entry.getName());
            Path targetPath = targetFile.getAbsoluteFile().toPath();
            if (entry.isDirectory()) {
                Files.createDirectories(targetPath, new FileAttribute[0]);
            } else {
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                try (InputStream in = zipFile.getInputStream(entry);){
                    Files.copy(in, targetPath, new CopyOption[0]);
                }
            }
            return targetPath.toFile();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private File preventZipSlip(File destinationDir, String name) throws IOException {
        File destFile = new File(destinationDir, name);
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + name);
        }
        return destFile;
    }

    private void ensureFileDoesNotYetExist(File target) throws IOException {
        if (target.exists()) {
            throw new IOException("File already exists: " + target.getAbsolutePath());
        }
    }

    public static class RuntimeIOException
    extends RuntimeException {
        RuntimeIOException(IOException e) {
            super(e);
        }

        @Override
        public IOException getCause() {
            return (IOException)super.getCause();
        }
    }
}

