/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import nl.hsac.fitnesse.fixture.util.selenium.SeleniumHelper;
import nl.hsac.fitnesse.fixture.util.selenium.by.ConstantBy;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebElement;

public class AllFramesDecorator<T> {
    private final SeleniumHelper helper;
    private final Function<T, Boolean> isFinished;
    private int frameDepthOnStart;

    public AllFramesDecorator(SeleniumHelper aHelper) {
        this(aHelper, null);
    }

    public AllFramesDecorator(SeleniumHelper aHelper, Function<T, Boolean> anIsFinishedFunction) {
        this.helper = aHelper;
        this.isFinished = anIsFinishedFunction;
    }

    public T apply(Supplier<T> aSupplier) {
        T result = aSupplier.get();
        if (!this.isFinished(result)) {
            this.frameDepthOnStart = this.helper.getCurrentFrameDepth();
            result = this.invokeInFrames(aSupplier);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T invokeInFrames(Supplier<T> aSupplier) {
        T result = null;
        List frames = this.helper.findElements(ConstantBy.frames());
        for (WebElement frame : frames) {
            SearchContext currentContext = this.helper.getCurrentContext();
            if (currentContext == this.helper.driver()) {
                currentContext = null;
            }
            this.helper.switchToFrame(frame);
            try {
                result = aSupplier.get();
                if (!this.isFinished(result) && !this.isFinished(result = (T)this.invokeInFrames(aSupplier))) continue;
                break;
            }
            finally {
                if (this.helper.getFrameDepthOnLastAlertError() != 0) continue;
                int depthOnAlert = this.helper.getCurrentFrameDepth();
                try {
                    this.helper.switchToParentFrame();
                    if (currentContext == null) continue;
                    this.helper.setCurrentContext(currentContext);
                }
                catch (UnhandledAlertException e) {
                    this.helper.storeFrameDepthOnAlertError(depthOnAlert - this.frameDepthOnStart);
                }
            }
        }
        return result;
    }

    private boolean isFinished(T result) {
        return this.isFinished != null && this.isFinished.apply(result) != false;
    }
}

