/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium;

import java.util.Set;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;

public class CookieConverter {
    public void copySeleniumCookies(Set<org.openqa.selenium.Cookie> browserCookies, CookieStore cookieStore) {
        for (org.openqa.selenium.Cookie browserCookie : browserCookies) {
            ClientCookie cookie = this.convertCookie(browserCookie);
            cookieStore.addCookie((Cookie)cookie);
        }
    }

    protected ClientCookie convertCookie(org.openqa.selenium.Cookie browserCookie) {
        BasicClientCookie cookie = new BasicClientCookie(browserCookie.getName(), browserCookie.getValue());
        String domain = browserCookie.getDomain();
        if (domain != null && domain.startsWith(".")) {
            domain = domain.substring(1);
        }
        cookie.setDomain(domain);
        cookie.setPath(browserCookie.getPath());
        cookie.setExpiryDate(browserCookie.getExpiry());
        cookie.setSecure(browserCookie.isSecure());
        if (browserCookie.isHttpOnly()) {
            cookie.setAttribute("httponly", "");
        }
        return cookie;
    }
}

