/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium;

import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WrapsDriver;

public class JavascriptHelper {
    public static JavascriptExecutor getJavascriptExecutor(SearchContext searchContext) {
        WrapsDriver wraps;
        WebDriver wrapped;
        JavascriptExecutor executor = null;
        if (searchContext instanceof JavascriptExecutor) {
            executor = (JavascriptExecutor)searchContext;
        } else if (searchContext instanceof WrapsDriver && (wrapped = (wraps = (WrapsDriver)searchContext).getWrappedDriver()) instanceof JavascriptExecutor) {
            executor = (JavascriptExecutor)wrapped;
        }
        if (executor == null) {
            throw new IllegalArgumentException("Unable to get: " + JavascriptExecutor.class.getName() + " from: " + searchContext.getClass().getName());
        }
        return executor;
    }

    public static Object executeScript(JavascriptExecutor jse, String script, Object ... parameters) {
        Object result;
        try {
            result = jse.executeScript(script, parameters);
        }
        catch (WebDriverException e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("Detected a page unload event; script execution does not work across page loads.")) {
                result = jse.executeScript(script, parameters);
            }
            throw e;
        }
        return result;
    }

    public static Object waitForJavascriptCallback(JavascriptExecutor jse, String statementPattern, Object ... parameters) {
        String script = "var callback = arguments[arguments.length - 1];" + String.format(statementPattern, parameters);
        Object result = statementPattern.contains("arguments") ? jse.executeAsyncScript(script, parameters) : jse.executeAsyncScript(script, new Object[0]);
        return result;
    }
}

