/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium;

public class NgClientSideScripts {
    public static final String WaitForAngular = "var rootSelector = arguments[0];\nvar el = document.querySelector(rootSelector);\n\n  try {\n    if (!window.angular) {\n      throw new Error('angular could not be found on the window');\n    }\n    if (angular.getTestability) {\n      angular.getTestability(el).whenStable(callback);\n    } else {\n      if (!angular.element(el).injector()) {\n        throw new Error('root element (' + rootSelector + ') has no injector.' +\n           ' this may mean it is not inside ng-app.');\n      }\n      angular.element(el).injector().get('$browser').\n          notifyWhenNoOutstandingRequests(callback);\n    }\n  } catch (err) {\n    callback(err.message);\n  }";
    public static final String TestForAngular = "var asyncCallback = arguments[1];\nvar attempts = arguments[0];\n  var callback = function(args) {\n    setTimeout(function() {\n      asyncCallback(args);\n    }, 0);\n  };\n  var check = function(n) {\n    try {\n      if (window.angular && window.angular.resumeBootstrap) {\n        callback([true, null]);\n      } else if (n < 1) {\n        if (window.angular) {\n          callback([false, 'angular never provided resumeBootstrap']);\n        } else {\n          callback([false, 'retries looking for angular exceeded']);\n        }\n      } else {\n        window.setTimeout(function() {check(n - 1);}, 1000);\n      }\n    } catch (e) {\n      callback([false, e]);\n    }\n  };\n  check(attempts);";
    public static final String ResumeAngularBootstrap = "angular.resumeBootstrap(arguments[0].length ? arguments[0].split(',') : []);";
    public static final String GetLocationAbsUrl = "var selector = arguments[0];\n  var el = document.querySelector(selector);\n  if (angular.getTestability) {\n    return angular.getTestability(el).\n        getLocation();\n  }\n  return angular.element(el).injector().get('$location').absUrl();\n";
    public static final String Evaluate = "var element = arguments[1];\nvar expression = arguments[0];\nreturn angular.element(element).scope().$eval(expression);";
    public static final String FindBindings = "var rootSelector = arguments[3];\nvar using = arguments[2];\nvar exactMatch = arguments[1];\nvar binding = arguments[0];\n  var root = document.querySelector(rootSelector || 'body');\n  using = using || document;\n  if (angular.getTestability) {\n    return angular.getTestability(root).\n        findBindings(using, binding, exactMatch);\n  }\n  var bindings = using.getElementsByClassName('ng-binding');\n  var matches = [];\n  for (var i = 0; i < bindings.length; ++i) {\n    var dataBinding = angular.element(bindings[i]).data('$binding');\n    if (dataBinding) {\n      var bindingName = dataBinding.exp || dataBinding[0].exp || dataBinding;\n      if (exactMatch) {\n        var matcher = new RegExp('({|\\\\s|^|\\\\|)' + binding + '(}|\\\\s|$|\\\\|)');\n        if (matcher.test(bindingName)) {\n          matches.push(bindings[i]);\n        }\n      } else {\n        if (bindingName.indexOf(binding) != -1) {\n          matches.push(bindings[i]);\n        }\n      }\n\n    }\n  }\n  return matches; /* Return the whole array for webdriver.findElements. */\n";
    public static final String FindSelects = "var using = arguments[1] || document;\nvar model = arguments[0];\nvar prefixes = ['ng-', 'ng_', 'data-ng-', 'x-ng-', 'ng\\\\:'];\nfor (var p = 0; p < prefixes.length; ++p) {\n    var selector = 'select[' + prefixes[p] + 'model=\"' + model + '\"]';\n    var inputs = using.querySelectorAll(selector);\n    if (inputs.length) {\n        return inputs;\n    }\n}";
    public static final String FindElements = "var using = arguments[1] || document;\nvar model = arguments[0];\nvar rootSelector = arguments[2];\nvar root = document.querySelector(rootSelector || 'body');\n  using = using || document;\n\n  if (angular.getTestability) {\n    return angular.getTestability(root).\n        findModels(using, model, true);\n  }\n  var prefixes = ['ng-', 'ng_', 'data-ng-', 'x-ng-', 'ng\\\\:'];\n  for (var p = 0; p < prefixes.length; ++p) {\n    var selector = '[' + prefixes[p] + 'model=\"' + model + '\"]';\n    var elements = using.querySelectorAll(selector);\n    if (elements.length) {\n      return elements;\n    }\n  }";
    public static final String FindAllRepeaterRows = "var using = arguments[2] || document;\nvar exact = arguments[1];\nvar repeater = arguments[0];\n  function repeaterMatch(ngRepeat, repeater, exact) {\n    if (exact) {\n      return ngRepeat.split(' track by ')[0].split(' as ')[0].split('|')[0].\n          trim() == repeater;\n    } else {\n      return ngRepeat.indexOf(repeater) != -1;\n    }\n  }\n\n  using = using || document;\n\n  var rows = [];\n  var prefixes = ['ng-', 'ng_', 'data-ng-', 'x-ng-', 'ng\\\\:'];\n  for (var p = 0; p < prefixes.length; ++p) {\n    var attr = prefixes[p] + 'repeat';\n    var repeatElems = using.querySelectorAll('[' + attr + ']');\n    attr = attr.replace(/\\\\/g, '');\n    for (var i = 0; i < repeatElems.length; ++i) {\n      if (repeaterMatch(repeatElems[i].getAttribute(attr), repeater, exact)) {\n        rows.push(repeatElems[i]);\n      }\n    }\n  }\n  for (var p = 0; p < prefixes.length; ++p) {\n    var attr = prefixes[p] + 'repeat-start';\n    var repeatElems = using.querySelectorAll('[' + attr + ']');\n    attr = attr.replace(/\\\\/g, '');\n    for (var i = 0; i < repeatElems.length; ++i) {\n      if (repeaterMatch(repeatElems[i].getAttribute(attr), repeater, exact)) {\n        var elem = repeatElems[i];\n        while (elem.nodeType != 8 ||\n            !repeaterMatch(elem.nodeValue, repeater, exact)) {\n          if (elem.nodeType == 1) {\n            rows.push(elem);\n          }\n          elem = elem.nextSibling;\n        }\n      }\n    }\n  }\n  return rows;";
}

