/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.util.FileUtil;
import nl.hsac.fitnesse.fixture.util.selenium.SeleniumHelper;
import nl.hsac.fitnesse.fixture.util.selenium.by.ConstantBy;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class PageSourceSaver {
    private static final Pattern BASE_TAG_EXPR = Pattern.compile("<base\\s+href=.+?>", 2);
    private static final String FAKE_SRC_ATTR = "data-fake_src";
    private final String pageSourceBase;
    private final Environment environment = Environment.getInstance();
    private final SeleniumHelper helper;

    public PageSourceSaver(String pageSourceBase, SeleniumHelper helper) {
        this.pageSourceBase = pageSourceBase;
        this.helper = helper;
    }

    public String savePageSource(String fileName) {
        ArrayList<WebElement> framesWithFakeSources = new ArrayList<WebElement>(2);
        HashMap<String, String> sourceReplacements = new HashMap<String, String>();
        List<WebElement> frames = this.getFrames();
        for (WebElement frame : frames) {
            String newLocation = this.saveFrameSource(frame);
            if (newLocation == null) continue;
            String fullUrlOfFrame = frame.getAttribute("src");
            if (StringUtils.isEmpty((CharSequence)fullUrlOfFrame)) {
                framesWithFakeSources.add(frame);
                fullUrlOfFrame = "anonymousFrame" + frames.indexOf(frame);
                this.addFakeSourceAttr(frame, fullUrlOfFrame);
            }
            this.addSourceReplacementsForFrame(sourceReplacements, newLocation, fullUrlOfFrame);
        }
        String source = this.getCurrentFrameSource(sourceReplacements);
        if (!framesWithFakeSources.isEmpty()) {
            source = source.replace(" data-fake_src=", " src=");
            this.removeFakeSourceAttr(framesWithFakeSources);
        }
        return this.saveSourceAsPageSource(fileName, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String saveFrameSource(WebElement frame) {
        SeleniumHelper helper = this.getSeleniumHelper();
        SearchContext currentContext = helper.getCurrentContext();
        helper.switchToFrame(frame);
        try {
            String fileName = helper.getResourceNameFromLocation();
            String string = this.savePageSource(fileName);
            helper.switchToParentFrame();
            if (currentContext != null) {
                helper.setCurrentContext(currentContext);
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                helper.switchToParentFrame();
                if (currentContext != null) {
                    helper.setCurrentContext(currentContext);
                }
                throw throwable;
            }
            catch (Exception e) {
                System.err.println("Error saving sources of nested (i)frame: " + frame);
                e.printStackTrace();
                return null;
            }
        }
    }

    protected String getCurrentFrameSource(Map<String, String> sourceReplacements) {
        Matcher matcher;
        String source = this.getCurrentPageSource();
        if (sourceReplacements != null && !sourceReplacements.isEmpty() && (matcher = BASE_TAG_EXPR.matcher(source = this.replaceSourceOfFrames(sourceReplacements, source))).find()) {
            source = matcher.replaceAll("<!--Commented out when saving page source $0-->");
        }
        return source;
    }

    protected String replaceSourceOfFrames(Map<String, String> sourceReplacements, String html) {
        for (Map.Entry<String, String> entry : sourceReplacements.entrySet()) {
            String originalLocation = entry.getKey();
            String newLocation = entry.getValue();
            html = html.replace("src=\"" + originalLocation + "\"", "src=\"" + newLocation + "\"");
        }
        return html;
    }

    protected void addSourceReplacementsForFrame(Map<String, String> sourceReplacements, String savedLocation, String fullUrlOfFrame) {
        String fullUrlOfParent = this.getLocation();
        int lastSlash = fullUrlOfParent.lastIndexOf("/");
        String baseUrl = fullUrlOfParent.substring(0, lastSlash + 1);
        String relativeUrlOfFrame = fullUrlOfFrame.replace(baseUrl, "");
        String relativePathToSaved = savedLocation.replace("files/pagesources/", "");
        sourceReplacements.put(fullUrlOfFrame, relativePathToSaved);
        sourceReplacements.put(relativeUrlOfFrame, relativePathToSaved);
        String framePathAndQuery = this.getPathAndQuery(fullUrlOfFrame);
        if (framePathAndQuery != null) {
            sourceReplacements.put(framePathAndQuery, relativePathToSaved);
        }
    }

    protected String getPathAndQuery(String urlString) {
        String path = null;
        try {
            URL url = new URL(urlString);
            path = url.getPath();
            String query = url.getQuery();
            if (query != null) {
                path = path + "?" + query;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return path;
    }

    protected String saveSourceAsPageSource(String fileName, String source) {
        byte[] content;
        String ext;
        String pageSourceName = this.getPageSourceName(fileName);
        String file = FileUtil.saveToFile(pageSourceName, ext = this.getPageSourceExtension(), content = this.convertSourceToBytes(source));
        String wikiUrl = this.getWikiUrl(file);
        String result = wikiUrl != null ? wikiUrl : file;
        return result;
    }

    protected String getPageSourceExtension() {
        return "html";
    }

    protected String getCurrentPageSource() {
        return this.getSeleniumHelper().getHtml();
    }

    protected byte[] convertSourceToBytes(String source) {
        try {
            return source.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to save source", e);
        }
    }

    protected String getWikiUrl(String filePath) {
        return this.environment.getWikiUrl(filePath);
    }

    protected List<WebElement> getFrames() {
        return this.getDriver().findElements(ConstantBy.frames());
    }

    protected String getLocation() {
        return this.getDriver().getCurrentUrl();
    }

    protected void addFakeSourceAttr(WebElement frame, String s) {
        this.executeJavascript("arguments[0].setAttribute(arguments[1], arguments[2]);", frame, FAKE_SRC_ATTR, s);
    }

    protected void removeFakeSourceAttr(List<WebElement> framesWithFakeSources) {
        for (WebElement frame : framesWithFakeSources) {
            this.executeJavascript("arguments[0].removeAttribute(arguments[1]);", frame, FAKE_SRC_ATTR);
        }
    }

    protected void executeJavascript(String pattern, Object ... params) {
        try {
            this.getSeleniumHelper().executeJavascript(pattern, params);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected WebDriver getDriver() {
        return this.getSeleniumHelper().driver();
    }

    protected String getPageSourceName(String fileName) {
        return this.pageSourceBase + fileName;
    }

    protected SeleniumHelper getSeleniumHelper() {
        return this.helper;
    }
}

