/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import nl.hsac.fitnesse.fixture.util.FileUtil;
import nl.hsac.fitnesse.fixture.util.FirstNonNullHelper;
import nl.hsac.fitnesse.fixture.util.selenium.JavascriptHelper;
import nl.hsac.fitnesse.fixture.util.selenium.PageSourceSaver;
import nl.hsac.fitnesse.fixture.util.selenium.StaleContextException;
import nl.hsac.fitnesse.fixture.util.selenium.TryAllFramesConditionDecorator;
import nl.hsac.fitnesse.fixture.util.selenium.by.ConstantBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.CssBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.ElementBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.FirstElementBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.InputBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.IsDisplayedFilter;
import nl.hsac.fitnesse.fixture.util.selenium.by.IsInteractableFilter;
import nl.hsac.fitnesse.fixture.util.selenium.by.JavascriptBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.LabelBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.LinkBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.TechnicalSelectorBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.TextBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.ToClickBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.XPathBy;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.ScreenshotException;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class SeleniumHelper<T extends WebElement> {
    private static final String ELEMENT_ON_SCREEN_JS = "if (arguments[0].getBoundingClientRect) {\nvar rect = arguments[0].getBoundingClientRect();\nreturn (\n  rect.top >= 0 &&\n  rect.left >= 0 &&\n  rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&\n  rect.right <= (window.innerWidth || document.documentElement.clientWidth));\n} else { return null; }";
    private static final String ALL_DIRECT_TEXT_CONTENT = "var element = arguments[0], text = '';\nfor (var i = 0; i < element.childNodes.length; ++i) {\n  var node = element.childNodes[i];\n  if (node.nodeType == Node.TEXT_NODE && node.textContent.trim() != '')\n    text += node.textContent.trim();\n}\nreturn text;";
    private static final String DRAG_AND_DROP_SIM_JS_RESOURCE = "js/dragDropSim.js";
    private static final char NON_BREAKING_SPACE = '\u00a0';
    private final List<T> currentIFramePath = new ArrayList<T>(4);
    private int frameDepthOnLastAlertError;
    private WebDriver webDriver;
    private WebDriverWait webDriverWait;
    private SearchContext currentContext;
    private boolean currentContextIsStale = false;

    public void setWebDriver(WebDriver aWebDriver, int defaultTimeout) {
        if (this.webDriver != null && !this.webDriver.equals(aWebDriver)) {
            this.webDriver.quit();
        }
        this.webDriver = aWebDriver;
        this.webDriverWait = this.webDriver == null ? null : new WebDriverWait(this.webDriver, (long)defaultTimeout);
    }

    public void close() {
        this.setWebDriver(null, 0);
    }

    public String getPageTitle() {
        return this.driver().getTitle();
    }

    public WebDriver.Navigation navigate() {
        return this.driver().navigate();
    }

    public T getElementToClick(String place) {
        return this.findByTechnicalSelectorOr(place, ToClickBy::heuristic);
    }

    public T getLink(String place) {
        return this.findByTechnicalSelectorOr(place, LinkBy::heuristic);
    }

    public T getElement(String place) {
        return this.findByTechnicalSelectorOr(place, ElementBy::heuristic);
    }

    public T getElementToCheckVisibility(String place) {
        return this.findByTechnicalSelectorOr(place, () -> {
            T result = this.findElement(TextBy.partial(place));
            if (!IsDisplayedFilter.mayPass(result)) {
                result = this.findElement(ToClickBy.heuristic(place));
            }
            return result;
        });
    }

    public T findByTechnicalSelectorOr(String place, Function<String, By> byFunction) {
        By by = this.placeToBy(place);
        if (by == null) {
            by = byFunction.apply(place);
        }
        return this.findElement(by);
    }

    public T findByTechnicalSelectorOr(String possibleTechnicalSelector, Supplier<? extends T> ... suppliers) {
        By by = this.placeToBy(possibleTechnicalSelector);
        Object element = by != null ? this.findElement(by) : (suppliers.length == 1 ? (WebElement)suppliers[0].get() : (WebElement)FirstNonNullHelper.firstNonNull(suppliers));
        return element;
    }

    public By placeToBy(String place) {
        return TechnicalSelectorBy.forPlace(place);
    }

    public boolean isInteractable(WebElement element) {
        return IsInteractableFilter.mayPass(element);
    }

    public T getLabelledElement(T label) {
        return (T)this.doInCurrentContext(c -> LabelBy.getLabelledElement(c, label));
    }

    public T getNestedElementForValue(T parent) {
        return ConstantBy.nestedElementForValue().findElement((SearchContext)parent);
    }

    public Integer getNumberFor(WebElement element) {
        Integer number = null;
        if ("li".equalsIgnoreCase(element.getTagName()) && element.isDisplayed()) {
            int num;
            String ownVal = element.getAttribute("value");
            if (ownVal != null && !"0".equals(ownVal)) {
                num = this.toInt(ownVal, 0);
            } else {
                String start = element.findElement(By.xpath((String)"ancestor::ol")).getAttribute("start");
                num = this.toInt(start, 1);
                List allItems = element.findElements(By.xpath((String)"ancestor::ol/li"));
                int index = allItems.indexOf(element);
                for (int i = 0; i < index; ++i) {
                    String val;
                    int valNum;
                    WebElement item = (WebElement)allItems.get(i);
                    if (!item.isDisplayed() || (valNum = this.toInt(val = item.getAttribute("value"), ++num)) == 0) continue;
                    num = valNum + 1;
                }
            }
            number = num;
        }
        return number;
    }

    private int toInt(String attributeValue, int defaultVal) {
        int result = defaultVal;
        if (attributeValue != null) {
            try {
                result = Integer.parseInt(attributeValue);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unable to parse value: " + attributeValue, e);
            }
        }
        return result;
    }

    public ArrayList<String> getAvailableOptions(WebElement element) {
        ArrayList<String> result = null;
        if (this.isInteractable(element) && "select".equalsIgnoreCase(element.getTagName())) {
            result = new ArrayList<String>();
            List options = element.findElements(By.tagName((String)"option"));
            for (WebElement option : options) {
                if (!option.isEnabled()) continue;
                result.add(option.getText());
            }
        }
        return result;
    }

    public int countVisibleOccurrences(String text, boolean checkOnScreen) {
        By findAllTexts = TextBy.partial(text);
        List<T> texts = this.findElements(findAllTexts);
        int result = this.countDisplayedElements(texts, text, checkOnScreen);
        By findAllInputs = InputBy.partialNormalizedValue(text);
        List<T> inputs = this.findElements(findAllInputs);
        return result += this.countDisplayedValues(inputs, text, checkOnScreen);
    }

    private int countDisplayedElements(List<T> elements, String textToFind, boolean checkOnScreen) {
        int result = 0;
        for (WebElement element : elements) {
            if (!this.checkVisible(element, checkOnScreen)) continue;
            if ("option".equalsIgnoreCase(element.getTagName())) {
                WebElement select = element.findElement(By.xpath((String)"./ancestor::select"));
                Select s = new Select(select);
                if (s == null || s.isMultiple()) {
                    int occurrencesInText = this.getOccurrencesInText(element, textToFind);
                    result += occurrencesInText;
                    continue;
                }
                WebElement selected = s.getFirstSelectedOption();
                if (!element.equals(selected)) continue;
                int occurrencesInText = this.getOccurrencesInText(element, textToFind);
                result += occurrencesInText;
                continue;
            }
            int occurrencesInText = this.getOccurrencesInText(element, textToFind);
            result += occurrencesInText;
        }
        return result;
    }

    private int getOccurrencesInText(WebElement element, String textToFind) {
        String elementText = this.getAllDirectText(element);
        return this.countOccurrences(elementText, textToFind);
    }

    private int countDisplayedValues(List<T> elements, String textToFind, boolean checkOnScreen) {
        int result = 0;
        for (WebElement element : elements) {
            if (!this.checkVisible(element, checkOnScreen)) continue;
            String value = element.getAttribute("value");
            int occurrencesInValue = this.countOccurrences(value, textToFind);
            result += occurrencesInValue;
        }
        return result;
    }

    public boolean checkVisible(WebElement element, boolean checkOnScreen) {
        boolean result = false;
        if (IsDisplayedFilter.mayPass(element)) {
            result = checkOnScreen ? this.isElementOnScreen(element) : true;
        }
        return result;
    }

    private int countOccurrences(String value, String textToFind) {
        String normalizedValue = XPathBy.getNormalizedText(value);
        return StringUtils.countMatches((CharSequence)normalizedValue, (CharSequence)textToFind);
    }

    public String getText(WebElement element) {
        String text = element.getText();
        if (text != null) {
            text = text.replace('\u00a0', ' ');
            text = text.trim();
        }
        return text;
    }

    public String getAllDirectText(WebElement element) {
        return (String)this.executeJavascript(ALL_DIRECT_TEXT_CONTENT, element);
    }

    public void fillDateInput(WebElement element, String value) {
        this.executeJavascript("arguments[0].value = arguments[1]", element, value);
    }

    public boolean setHiddenInputValue(String idOrName, String value) {
        T element = this.findElement(By.id((String)idOrName));
        if (element == null) {
            element = this.findElement(By.name((String)idOrName));
            if (element != null) {
                this.executeJavascript("document.getElementsByName('%s')[0].value='%s'", idOrName, value);
            }
        } else {
            this.executeJavascript("document.getElementById('%s').value='%s'", idOrName, value);
        }
        return element != null;
    }

    public Object executeJavascript(String statementPattern, Object ... parameters) {
        String script = String.format(statementPattern, parameters);
        Object result = statementPattern.contains("arguments") ? this.executeScript(script, parameters) : this.executeScript(script, new Object[0]);
        return result;
    }

    protected Object executeScript(String script, Object ... parameters) {
        JavascriptExecutor jse = (JavascriptExecutor)this.driver();
        Object result = JavascriptHelper.executeScript(jse, script, parameters);
        return result;
    }

    public Object waitForJavascriptCallback(String statementPattern, Object ... parameters) {
        JavascriptExecutor jse = (JavascriptExecutor)this.driver();
        Object result = JavascriptHelper.waitForJavascriptCallback(jse, statementPattern, parameters);
        return result;
    }

    public By byCss(String pattern, String ... parameters) {
        return new CssBy(pattern, parameters);
    }

    public By byXpath(String pattern, String ... parameters) {
        return new XPathBy(pattern, parameters);
    }

    public By byJavascript(String pattern, Object ... arguments) {
        return new JavascriptBy(pattern, arguments);
    }

    public Boolean isElementOnScreen(WebElement element) {
        return (Boolean)this.executeJavascript(ELEMENT_ON_SCREEN_JS, element);
    }

    public void setImplicitlyWait(int implicitWait) {
        try {
            this.driver().manage().timeouts().implicitlyWait((long)implicitWait, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            System.err.println("Unable to set implicit timeout (known issue for Safari): " + e.getMessage());
        }
    }

    public void setScriptWait(int scriptTimeout) {
        try {
            this.driver().manage().timeouts().setScriptTimeout((long)scriptTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            System.err.println("Unable to set script timeout (known issue for Safari): " + e.getMessage());
        }
    }

    public void setPageLoadWait(int pageLoadWait) {
        try {
            this.driver().manage().timeouts().pageLoadTimeout((long)pageLoadWait, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            System.err.println("Unable to set page load timeout (known issue for Safari): " + e.getMessage());
        }
    }

    public void hoverOver(WebElement element) {
        this.getActions().moveToElement(element).perform();
    }

    public Actions moveToElement(WebElement element, Integer xOffset, Integer yOffset) {
        return this.getActions().moveToElement(element, xOffset.intValue(), yOffset.intValue());
    }

    public void clickAtOffsetXY(WebElement element, Integer xOffset, Integer yOffset) {
        this.moveToElement(element, xOffset, yOffset).click().build().perform();
    }

    public void rightClickAtOffsetXY(WebElement element, Integer xOffset, Integer yOffset) {
        this.moveToElement(element, xOffset, yOffset).contextClick().build().perform();
    }

    public void doubleClickAtOffsetXY(WebElement element, Integer xOffset, Integer yOffset) {
        this.moveToElement(element, xOffset, yOffset).doubleClick().build().perform();
    }

    public void dragAndDropToOffsetXY(WebElement element, Integer xOffset, Integer yOffset) {
        this.getActions().dragAndDropBy(element, xOffset.intValue(), yOffset.intValue()).build().perform();
    }

    public void doubleClick(WebElement element) {
        this.getActions().doubleClick(element).perform();
    }

    public void rightClick(WebElement element) {
        this.getActions().contextClick(element).perform();
    }

    public void clickWithKeyDown(WebElement element, CharSequence key) {
        this.getActions().keyDown(key).click(element).keyUp(key).perform();
    }

    public void dragAndDrop(WebElement source, WebElement target) {
        this.getActions().dragAndDrop(source, target).perform();
    }

    public void html5DragAndDrop(WebElement source, WebElement target) throws IOException {
        URL url = Resources.getResource((String)DRAG_AND_DROP_SIM_JS_RESOURCE);
        String js = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        this.executeJavascript(js + " DndSimulator.simulate(arguments[0], arguments[1]);", source, target);
    }

    public Actions getActions() {
        return new Actions(this.driver());
    }

    public T getActiveElement() {
        return (T)this.getTargetLocator().activeElement();
    }

    public boolean selectAll() {
        boolean result = false;
        T element = this.getActiveElement();
        if (element != null) {
            if (this.connectedToMac()) {
                this.executeJavascript("arguments[0].select()", element);
            } else {
                element.sendKeys(new CharSequence[]{Keys.CONTROL, "a"});
            }
            result = true;
        }
        return result;
    }

    public boolean copy() {
        boolean result = false;
        T element = this.getActiveElement();
        if (element != null) {
            if (this.connectedToMac()) {
                element.sendKeys(new CharSequence[]{Keys.CONTROL, Keys.INSERT});
            } else {
                element.sendKeys(new CharSequence[]{Keys.CONTROL, "c"});
            }
            result = true;
        }
        return result;
    }

    public boolean cut() {
        boolean result = false;
        T element = this.getActiveElement();
        if (element != null) {
            if (this.connectedToMac()) {
                element.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, Keys.INSERT}), Keys.BACK_SPACE});
            } else {
                element.sendKeys(new CharSequence[]{Keys.CONTROL, "x"});
            }
            result = true;
        }
        return result;
    }

    public boolean paste() {
        boolean result = false;
        T element = this.getActiveElement();
        if (element != null) {
            if (this.connectedToMac()) {
                element.sendKeys(new CharSequence[]{Keys.SHIFT, Keys.INSERT});
            } else {
                element.sendKeys(new CharSequence[]{Keys.CONTROL, "v"});
            }
            result = true;
        }
        return result;
    }

    public String getSelectionText() {
        return (String)this.executeJavascript("return window.getSelection? window.getSelection().toString() : \"\"", new Object[0]);
    }

    public T findByXPath(String pattern, String ... parameters) {
        By by = this.byXpath(pattern, parameters);
        return this.findElement(by);
    }

    public T findElement(By by) {
        return (T)this.doInCurrentContext(c -> this.findElement((SearchContext)c, by));
    }

    public List<T> findElements(By by) {
        return this.doInCurrentContext(c -> c.findElements(by));
    }

    public void setCurrentContext(SearchContext newContext) {
        this.currentContext = newContext;
        this.currentContextIsStale = false;
    }

    public SearchContext getCurrentContext() {
        WebDriver result;
        if (this.currentContext == null) {
            result = this.driver();
        } else {
            if (this.currentContextIsStale) {
                throw new StaleContextException(this.currentContext);
            }
            result = this.currentContext;
        }
        return result;
    }

    public <R> R doInCurrentContext(Function<SearchContext, ? extends R> function) {
        try {
            return function.apply(this.getCurrentContext());
        }
        catch (WebDriverException e) {
            if (this.isStaleElementException(e)) {
                this.currentContextIsStale = true;
                this.getCurrentContext();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R doInContext(SearchContext context, Supplier<R> action) {
        R result;
        if (context == null) {
            result = action.get();
        } else {
            SearchContext currentSearchContext = this.currentContext;
            boolean contextIsStale = this.currentContextIsStale;
            this.setCurrentContext(context);
            try {
                result = action.get();
            }
            finally {
                this.currentContext = currentSearchContext;
                this.currentContextIsStale = contextIsStale;
            }
        }
        return result;
    }

    public T findElement(By by, int index) {
        WebElement element = null;
        List<T> elements = this.findElements(by);
        if (elements.size() > index) {
            element = (WebElement)elements.get(index);
        }
        return (T)element;
    }

    public String getSessionId() {
        SessionId s;
        String result = null;
        WebDriver d = this.driver();
        if (d instanceof RemoteWebDriver && (s = ((RemoteWebDriver)d).getSessionId()) != null) {
            result = s.toString();
        }
        return result;
    }

    public boolean connectedToInternetExplorer() {
        boolean result = false;
        WebDriver driver = this.driver();
        if (driver instanceof InternetExplorerDriver) {
            result = true;
        } else if (driver instanceof RemoteWebDriver) {
            result = this.checkRemoteBrowserName(driver, "internet explorer");
        }
        return result;
    }

    public boolean connectedToSafari() {
        boolean result = false;
        WebDriver driver = this.driver();
        if (driver instanceof SafariDriver) {
            result = true;
        } else if (driver instanceof RemoteWebDriver) {
            result = this.checkRemoteBrowserName(driver, "safari");
        }
        return result;
    }

    protected boolean checkRemoteBrowserName(WebDriver driver, String expectedName) {
        RemoteWebDriver remoteWebDriver = (RemoteWebDriver)driver;
        String browserName = remoteWebDriver.getCapabilities().getBrowserName();
        return expectedName.equalsIgnoreCase(browserName);
    }

    public Keys getControlOrCommand() {
        return this.connectedToMac() ? Keys.COMMAND : Keys.CONTROL;
    }

    public boolean connectedToMac() {
        RemoteWebDriver remoteWebDriver;
        Platform platform;
        WebDriver driver = this.driver();
        boolean isMac = driver instanceof RemoteWebDriver ? Platform.MAC == (platform = (remoteWebDriver = (RemoteWebDriver)driver).getCapabilities().getPlatform()) || Platform.MAC == platform.family() : SystemUtils.IS_OS_MAC;
        return isMac;
    }

    public WebDriver driver() {
        return this.webDriver;
    }

    public WebDriverWait waitDriver() {
        return this.webDriverWait;
    }

    public <T> T waitUntil(int maxSecondsToWait, ExpectedCondition<T> condition) {
        ExpectedCondition<T> cHandlingStale = this.getConditionIgnoringStaleElement(condition);
        FluentWait wait = this.waitDriver().withTimeout(Duration.ofSeconds(maxSecondsToWait));
        return (T)wait.until(cHandlingStale);
    }

    public <T> ExpectedCondition<T> getConditionIgnoringStaleElement(ExpectedCondition<T> condition) {
        return d -> {
            try {
                return condition.apply((Object)this.webDriver);
            }
            catch (WebDriverException e) {
                if (this.isStaleElementException(e)) {
                    return null;
                }
                throw e;
            }
        };
    }

    public boolean isStaleElementException(WebDriverException e) {
        boolean result = false;
        if (e instanceof StaleElementReferenceException) {
            result = true;
        } else {
            String msg = e.getMessage();
            if (msg != null) {
                result = msg.contains("Element does not exist in cache") || msg.contains("unknown error: unhandled inspector error: {\"code\":-32000,\"message\":\"Cannot find context with specified id\"}") || msg.contains("Error: element is not attached to the page document") || msg.contains("can't access dead object");
            }
        }
        return result;
    }

    public T findElement(SearchContext context, By by) {
        return FirstElementBy.getWebElement(by, context);
    }

    public void scrollTo(WebElement element, boolean toCenter) {
        String scrollIntoViewArgs = toCenter ? "{behavior: \"auto\", block: \"center\", inline: \"center\"}" : "true";
        this.executeJavascript("arguments[0].scrollIntoView(" + scrollIntoViewArgs + ");", element);
    }

    public String takeScreenshot(String baseName) {
        String result = null;
        WebDriver d = this.driver();
        if (!(d instanceof TakesScreenshot)) {
            d = new Augmenter().augment(d);
        }
        if (d instanceof TakesScreenshot) {
            TakesScreenshot ts = (TakesScreenshot)d;
            byte[] png = (byte[])ts.getScreenshotAs(OutputType.BYTES);
            result = this.writeScreenshot(baseName, png);
        }
        return result;
    }

    public byte[] findScreenshot(Throwable t) {
        byte[] result = null;
        if (t != null) {
            if (t instanceof ScreenshotException) {
                String encodedScreenshot = ((ScreenshotException)t).getBase64EncodedScreenshot();
                result = Base64.getDecoder().decode(encodedScreenshot);
            } else {
                result = this.findScreenshot(t.getCause());
            }
        }
        return result;
    }

    public String writeScreenshot(String baseName, byte[] png) {
        return FileUtil.saveToFile(baseName, "png", png);
    }

    public String getResourceNameFromLocation() {
        String fileName = "pageSource";
        try {
            String location = this.driver().getCurrentUrl();
            URL u = new URL(location);
            String file = FilenameUtils.getName((String)u.getPath());
            file = file.replaceAll("^(.*?)(\\.html?)?$", "$1");
            if (!"".equals(file)) {
                fileName = file;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return fileName;
    }

    public String getHtml() {
        String html;
        try {
            html = (String)this.executeJavascript("var node = document.doctype;\nvar docType = '';\nif (node) {\n  docType = \"<!DOCTYPE \"\n+ node.name\n+ (node.publicId ? ' PUBLIC \"' + node.publicId + '\"' : '')\n+ (!node.publicId && node.systemId ? ' SYSTEM' : '') \n+ (node.systemId ? ' \"' + node.systemId + '\"' : '')\n+ '>'; }\nvar html = document.documentElement.outerHTML || '<html>' + document.documentElement.innerHTML + '</html>';\nreturn docType + html;", new Object[0]);
        }
        catch (RuntimeException e) {
            try {
                html = this.driver().getPageSource();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw e;
            }
        }
        return html;
    }

    public PageSourceSaver getPageSourceSaver(String baseDir) {
        return new PageSourceSaver(baseDir, this);
    }

    public Dimension getWindowSize() {
        return this.getWindow().getSize();
    }

    public void setWindowSize(int newWidth, int newHeight) {
        this.getWindow().setSize(new Dimension(newWidth, newHeight));
    }

    public void setWindowSizeToMaximum() {
        this.getWindow().maximize();
    }

    public WebDriver.Window getWindow() {
        return this.driver().manage().window();
    }

    public int getCurrentTabIndex(List<String> tabHandles) {
        try {
            String currentHandle = this.driver().getWindowHandle();
            return tabHandles.indexOf(currentHandle);
        }
        catch (NoSuchWindowException e) {
            return -1;
        }
    }

    public void goToTab(List<String> tabHandles, int indexToGoTo) {
        this.getTargetLocator().window(tabHandles.get(indexToGoTo));
        this.switchToDefaultContent();
        this.setCurrentContext(null);
    }

    public List<String> getTabHandles() {
        return new ArrayList<String>(this.driver().getWindowHandles());
    }

    public void switchToDefaultContent() {
        this.getTargetLocator().defaultContent();
        if (!this.currentIFramePath.isEmpty()) {
            this.setCurrentContext(null);
            this.currentIFramePath.clear();
        }
    }

    public void switchToFrame(T iframe) {
        this.getTargetLocator().frame(iframe);
        this.setCurrentContext(null);
        this.currentIFramePath.add(iframe);
    }

    public void switchToParentFrame() {
        if (!this.currentIFramePath.isEmpty()) {
            List<T> newPath = this.currentIFramePath.subList(0, this.currentIFramePath.size() - 1);
            newPath = new ArrayList<T>(newPath);
            this.switchToDefaultContent();
            for (WebElement iframe : newPath) {
                this.switchToFrame(iframe);
            }
        }
    }

    public <T> ExpectedCondition<T> conditionForAllFrames(ExpectedCondition<T> nested) {
        return new TryAllFramesConditionDecorator<T>(this, nested);
    }

    public Alert getAlert() {
        Alert alert = null;
        try {
            alert = this.getTargetLocator().alert();
        }
        catch (NoAlertPresentException noAlertPresentException) {
            // empty catch block
        }
        return alert;
    }

    private WebDriver.TargetLocator getTargetLocator() {
        return this.driver().switchTo();
    }

    public Cookie getCookie(String cookieName) {
        return this.driver().manage().getCookieNamed(cookieName);
    }

    public Set<Cookie> getCookies() {
        return this.driver().manage().getCookies();
    }

    public void deleteAllCookies() {
        this.driver().manage().deleteAllCookies();
    }

    public int getCurrentFrameDepth() {
        return this.currentIFramePath.size();
    }

    public void storeFrameDepthOnAlertError(int frameDepthOnAlert) {
        this.frameDepthOnLastAlertError = frameDepthOnAlert;
    }

    public void resetFrameDepthOnAlertError() {
        int depthOnLastAlertError = this.getFrameDepthOnLastAlertError();
        for (int i = 0; i < depthOnLastAlertError; ++i) {
            this.switchToParentFrame();
            --this.frameDepthOnLastAlertError;
        }
    }

    public int getFrameDepthOnLastAlertError() {
        return this.frameDepthOnLastAlertError;
    }
}

