/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.by;

import java.util.List;
import java.util.function.BiFunction;
import nl.hsac.fitnesse.fixture.util.selenium.JavascriptHelper;
import nl.hsac.fitnesse.fixture.util.selenium.by.SingleElementOrNullBy;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class BestMatchBy<T extends WebElement>
extends SingleElementOrNullBy<T> {
    private static final String TOP_ELEMENT_AT = "if (arguments[0].getBoundingClientRect) {\n  var rect = arguments[0].getBoundingClientRect();\n  var x = (rect.left + rect.right)/2;\n  var y = (rect.top + rect.bottom)/2;\n  return document.elementFromPoint(x,y);\n} else { return null; }";
    private static BiFunction<SearchContext, List<WebElement>, ? extends WebElement> BEST_FUNCTION = BestMatchBy::selectBestElement;
    private final By by;

    public BestMatchBy(By nestedBy) {
        this.by = nestedBy;
    }

    @Override
    public T findElement(SearchContext context) {
        return BestMatchBy.findElement(this.by, context);
    }

    public static <T extends WebElement> T findElement(By by, SearchContext context) {
        WebElement element = null;
        List elements = context.findElements(by);
        if (elements.size() == 1) {
            element = (WebElement)elements.get(0);
        } else if (elements.size() > 1) {
            element = BEST_FUNCTION.apply(context, elements);
        }
        return (T)element;
    }

    public static WebElement selectBestElement(SearchContext context, List<WebElement> elements) {
        JavascriptExecutor jse = JavascriptHelper.getJavascriptExecutor(context);
        WebElement element = elements.get(0);
        WebElement firstDisplayed = null;
        WebElement firstOnTop = null;
        if (!element.isDisplayed() || !BestMatchBy.isOnTop(jse, element)) {
            for (int i = 1; i < elements.size(); ++i) {
                WebElement otherElement = elements.get(i);
                if (!otherElement.isDisplayed()) continue;
                if (firstDisplayed == null) {
                    firstDisplayed = otherElement;
                }
                if (!BestMatchBy.isOnTop(jse, otherElement)) continue;
                firstOnTop = otherElement;
                element = otherElement;
                break;
            }
            if (firstOnTop == null && firstDisplayed != null && !element.isDisplayed()) {
                element = firstDisplayed;
            }
        }
        return element;
    }

    private static <T extends WebElement> boolean isOnTop(JavascriptExecutor executor, T element) {
        WebElement e = (WebElement)JavascriptHelper.executeScript(executor, TOP_ELEMENT_AT, element);
        return element.equals(e);
    }

    public static BiFunction<SearchContext, List<WebElement>, ? extends WebElement> getBestFunction() {
        return BEST_FUNCTION;
    }

    public static void setBestFunction(BiFunction<SearchContext, List<WebElement>, ? extends WebElement> bestFunction) {
        BEST_FUNCTION = bestFunction;
    }

    @Override
    public String toString() {
        return "BestMatchOf: " + this.by;
    }
}

