/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.by;

import nl.hsac.fitnesse.fixture.util.selenium.by.BestMatchBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.SingleElementOrNullBy;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class ConstantBy {
    private static final By FRAME_BY = By.cssSelector((String)"iframe,frame");
    private static final BestMatchBy NESTED_ELEMENT_FOR_VALUE_BY = new BestMatchBy(By.cssSelector((String)"input:not([type='hidden']),select,textarea"));
    private static final BestMatchBy SUBMIT_BUTTON_BY = new BestMatchBy(By.cssSelector((String)"input[type='submit']:not([value])"));
    private static final BestMatchBy RESET_BUTTON_BY = new BestMatchBy(By.cssSelector((String)"input[type='reset']:not([value])"));
    private static final BestMatchBy CHECKBOX_BY = new BestMatchBy(By.cssSelector((String)"input[type='checkbox']"));
    private static final SingleElementOrNullBy NULL_BY = new FindsNothing();
    private static final By SELECTED_OPTIONS_BY = By.cssSelector((String)"option:checked");

    public static By frames() {
        return FRAME_BY;
    }

    public static BestMatchBy nestedElementForValue() {
        return NESTED_ELEMENT_FOR_VALUE_BY;
    }

    public static SingleElementOrNullBy submitOrReset(String placeWanted) {
        SingleElementOrNullBy result = ConstantBy.nothing();
        if ("submit".equals(placeWanted = placeWanted.toLowerCase())) {
            result = ConstantBy.submitButton();
        } else if ("reset".equals(placeWanted)) {
            result = ConstantBy.resetButton();
        }
        return result;
    }

    public static BestMatchBy submitButton() {
        return SUBMIT_BUTTON_BY;
    }

    public static BestMatchBy resetButton() {
        return RESET_BUTTON_BY;
    }

    public static SingleElementOrNullBy checkboxOrNothing(String placeWanted) {
        SingleElementOrNullBy result = "checkbox".equals(placeWanted = placeWanted.toLowerCase()) ? ConstantBy.checkbox() : ConstantBy.nothing();
        return result;
    }

    public static BestMatchBy checkbox() {
        return CHECKBOX_BY;
    }

    public static By getSelectedOptionsBy() {
        return SELECTED_OPTIONS_BY;
    }

    public static SingleElementOrNullBy nothing() {
        return NULL_BY;
    }

    private static final class FindsNothing
    extends SingleElementOrNullBy {
        private FindsNothing() {
        }

        public WebElement findElement(SearchContext context) {
            return null;
        }

        @Override
        public String toString() {
            return "FindsNothingBy";
        }
    }
}

