/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.by;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import nl.hsac.fitnesse.fixture.util.FirstNonNullHelper;
import nl.hsac.fitnesse.fixture.util.selenium.by.BestMatchBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.ConstantBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.SingleElementOrNullBy;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class FirstElementBy<T extends WebElement>
extends SingleElementOrNullBy<T> {
    private final List<By> byList;
    private Function<? super T, ? extends T> postProcessor;

    public FirstElementBy(Function<? super T, ? extends T> postProcessor, By firstBy, By ... bys) {
        int size = 1;
        if (bys != null) {
            size += bys.length;
        }
        this.byList = new ArrayList<By>(size);
        this.byList.add(firstBy);
        Collections.addAll(this.byList, bys);
        this.byList.removeIf(x -> ConstantBy.nothing() == x);
        this.setPostProcessor(postProcessor);
    }

    public FirstElementBy(By firstBy, By ... bys) {
        this(Function.identity(), firstBy, bys);
    }

    @Override
    public T findElement(SearchContext context) {
        return (T)FirstNonNullHelper.firstNonNull(by -> (WebElement)this.postProcessor.apply(FirstElementBy.getWebElement(by, context)), this.byList);
    }

    public static <T extends WebElement> T getWebElement(By by, SearchContext context) {
        Object byResult = by instanceof SingleElementOrNullBy ? by.findElement(context) : BestMatchBy.findElement(by, context);
        return (T)byResult;
    }

    public List<By> getByList() {
        return this.byList;
    }

    public void setPostProcessor(Function<? super T, ? extends T> postProcessor) {
        this.postProcessor = postProcessor;
    }

    public Function<? super T, ? extends T> getPostProcessor() {
        return this.postProcessor;
    }

    @Override
    public String toString() {
        return FirstElementBy.getByName(((Object)((Object)this)).getClass()) + this.byList;
    }
}

