/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.by;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.hsac.fitnesse.fixture.util.selenium.by.SingleElementOrNullBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.XPathBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.grid.Link;
import nl.hsac.fitnesse.fixture.util.selenium.by.grid.Row;
import nl.hsac.fitnesse.fixture.util.selenium.by.grid.Value;

public class GridBy {
    public static SingleElementOrNullBy coordinates(int columnIndex, int rowIndex) {
        return new Value.AtCoordinates(columnIndex, rowIndex);
    }

    public static SingleElementOrNullBy columnInRow(String requestedColumnName, int rowIndex) {
        return new Value.OfInRowNumber(requestedColumnName, rowIndex);
    }

    public static SingleElementOrNullBy columnInRowWhereIs(String requestedColumnName, String selectOnColumn, String selectOnValue) {
        return new Value.OfInRowWhereIs(requestedColumnName, selectOnValue, selectOnColumn);
    }

    public static XPathBy rowNumber(int rowIndex) {
        return new Row.InNumber(rowIndex);
    }

    public static XPathBy rowWhereIs(String selectOnColumn, String selectOnValue) {
        return new Row.WhereIs(selectOnValue, selectOnColumn);
    }

    public static SingleElementOrNullBy linkInRow(String place, int rowIndex) {
        return new Link.InRow(place, rowIndex);
    }

    public static SingleElementOrNullBy linkInRowWhereIs(String place, String selectOnColumn, String selectOnValue) {
        return new Link.InRowWhereIs(place, selectOnValue, selectOnColumn);
    }

    public static String getXPathForColumnInRowByValueInOtherColumn(String value, String columnName, String ... extraColumnNames) {
        String selectIndex = GridBy.getXPathForColumnIndex(columnName);
        String rowXPath = GridBy.getXPathForRowByValueInOtherColumn(selectIndex, value);
        String headerXPath = GridBy.getXPathForHeaderRowByHeaders(columnName, extraColumnNames);
        return String.format("(.//table[./%1$s and ./%2$s])[last()]/%2$s/td", headerXPath, rowXPath);
    }

    public static String getXPathForRowByValueInOtherColumn(String selectIndex, String value) {
        return String.format("/tr[td[%1$s]/descendant-or-self::text()[normalized(.)='%2$s']]", selectIndex, value);
    }

    public static String getXPathForColumnIndex(String columnName) {
        String headerXPath = GridBy.getXPathForHeaderCellWithText(columnName);
        return String.format("count(ancestor::table[1]//tr/%1$s/preceding-sibling::th)+1", headerXPath);
    }

    public static String getXPathForHeaderRowByHeaders(String columnName, String ... extraColumnNames) {
        String allHeadersPresent;
        if (extraColumnNames != null && extraColumnNames.length > 0) {
            int extraCount = extraColumnNames.length;
            String[] columnNames = new String[extraCount + 1];
            columnNames[0] = columnName;
            System.arraycopy(extraColumnNames, 0, columnNames, 1, extraCount);
            allHeadersPresent = Stream.of(columnNames).map(GridBy::getXPathForHeaderCellWithText).collect(Collectors.joining(" and "));
        } else {
            allHeadersPresent = GridBy.getXPathForHeaderCellWithText(columnName);
        }
        return String.format("/tr[%1$s]", allHeadersPresent);
    }

    public static String getXPathForHeaderCellWithText(String headerText) {
        return String.format("th[descendant-or-self::text()[normalized(.)='%1$s']]", headerText);
    }
}

