/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.by;

import nl.hsac.fitnesse.fixture.util.selenium.by.BestMatchBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.ConstantBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.SingleElementOrNullBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.XPathBy;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class LabelBy
extends SingleElementOrNullBy {
    private final By by;
    private final String text;

    public static By exact(String text) {
        return new Exact(text);
    }

    public static By partial(String partialText) {
        return new Partial(partialText);
    }

    protected LabelBy(String pattern, String textToFind) {
        this.by = new XPathBy(pattern, textToFind);
        this.text = textToFind;
    }

    public WebElement findElement(SearchContext context) {
        Object label = BestMatchBy.findElement(this.by, context);
        WebElement element = LabelBy.getLabelledElement(context, label);
        return element;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.text;
    }

    public static WebElement getLabelledElement(SearchContext context, WebElement label) {
        WebElement element = null;
        if (label != null) {
            String forAttr = label.getAttribute("for");
            element = forAttr == null || "".equals(forAttr) ? (WebElement)ConstantBy.nestedElementForValue().findElement((SearchContext)label) : (WebElement)BestMatchBy.findElement(By.id((String)forAttr), context);
        }
        return element;
    }

    public static class Partial
    extends LabelBy {
        public Partial(String partialText) {
            super(".//label[descendant-or-self::text()[contains(normalized(.), '%s')]]", partialText);
        }
    }

    public static class Exact
    extends LabelBy {
        public Exact(String text) {
            super(".//label[descendant-or-self::text()[normalized(.)='%s']]", text);
        }
    }
}

