/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.by;

import java.util.List;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public abstract class LazyPatternBy
extends By {
    private static final Pattern SINGLE_QUOTE_PATTERN = Pattern.compile("'");
    private final String pattern;
    private final String[] parameters;
    private By nested;

    public LazyPatternBy(String pattern, String ... parameters) {
        this.pattern = pattern;
        this.parameters = parameters;
    }

    public List<WebElement> findElements(SearchContext context) {
        return this.getNested().findElements(context);
    }

    public String toString() {
        return this.getNested().toString();
    }

    public int hashCode() {
        return this.getNested().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        By nested = this.getNested();
        if (o instanceof LazyPatternBy) {
            return nested.equals((Object)((LazyPatternBy)((Object)o)).getNested());
        }
        return nested.equals(o);
    }

    private final synchronized By getNested() {
        if (this.nested == null) {
            String expr = this.createExpression(this.pattern, this.parameters);
            this.nested = this.createNested(expr);
        }
        return this.nested;
    }

    protected abstract By createNested(String var1);

    protected String createExpression(String pattern, String ... parameters) {
        String result = parameters.length == 0 ? pattern : this.fillPattern(pattern, parameters);
        return result;
    }

    private String fillPattern(String pattern, String[] parameters) {
        boolean containsSingleQuote = false;
        boolean containsDoubleQuote = false;
        Object[] escapedParams = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String param = parameters[i];
            containsSingleQuote = containsSingleQuote || param.contains("'");
            containsDoubleQuote = containsDoubleQuote || param.contains("\"");
            escapedParams[i] = param;
        }
        if (containsDoubleQuote && containsSingleQuote) {
            throw new RuntimeException("Unsupported combination of single and double quotes");
        }
        String patternToUse = containsSingleQuote ? SINGLE_QUOTE_PATTERN.matcher(pattern).replaceAll("\"") : pattern;
        return String.format(patternToUse, escapedParams);
    }
}

