/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.by;

import nl.hsac.fitnesse.fixture.util.selenium.by.AltBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.AriaLabelBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.HeuristicBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.TitleBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.XPathBy;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class LinkBy {
    public static By heuristic(String place) {
        return new Heuristic(place);
    }

    public static By exactText(String text) {
        return new Exact(text);
    }

    public static By partialText(String partialText) {
        return new Partial(partialText);
    }

    public static class Heuristic
    extends HeuristicBy {
        private static final By FIND_PARENT_A_BY = By.xpath((String)"./ancestor::a");

        public Heuristic(String place) {
            super(LinkBy.exactText(place), AriaLabelBy.exact(place), TitleBy.exact(place), AltBy.exact(place), LinkBy.partialText(place), AriaLabelBy.partial(place), TitleBy.partial(place), AltBy.partial(place));
        }

        @Override
        public WebElement findElement(SearchContext context) {
            Object element = super.findElement(context);
            if (element != null && !"a".equalsIgnoreCase(element.getTagName())) {
                try {
                    element = FIND_PARENT_A_BY.findElement(element);
                }
                catch (NoSuchElementException e) {
                    element = null;
                }
            }
            return element;
        }
    }

    public static class Partial
    extends HeuristicBy {
        public Partial(String partialText) {
            super(By.partialLinkText((String)partialText), new XPathBy(".//a[descendant-or-self::text()[contains(normalized(.),'%s')]]", partialText));
        }
    }

    public static class Exact
    extends HeuristicBy {
        public Exact(String text) {
            super(By.linkText((String)text), new XPathBy(".//a[descendant-or-self::text()[normalized(.)='%s']]", text));
        }
    }
}

