/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.by;

import java.util.function.Function;
import nl.hsac.fitnesse.fixture.util.FirstNonNullHelper;
import nl.hsac.fitnesse.fixture.util.selenium.by.XPathBy;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;

public class TechnicalSelectorBy {
    private static final Function<String, By> ID_BY = TechnicalSelectorBy.byIfStartsWith("id", By::id);
    private static final Function<String, By> CSS_BY = TechnicalSelectorBy.byIfStartsWith("css", By::cssSelector);
    private static final Function<String, By> NAME_BY = TechnicalSelectorBy.byIfStartsWith("name", By::name);
    private static final Function<String, By> LINKTEXT_BY = TechnicalSelectorBy.byIfStartsWith("link", By::linkText);
    private static final Function<String, By> PARTIALLINKTEXT_BY = TechnicalSelectorBy.byIfStartsWith("partialLink", By::partialLinkText);
    private static final Function<String, By> XPATH_BY = TechnicalSelectorBy.byIfStartsWith("xpath", x$0 -> new XPathBy((String)x$0, new String[0]));

    public static boolean isTechnicalSelector(String place) {
        return StringUtils.startsWithAny((CharSequence)place, (CharSequence[])new CharSequence[]{"id=", "xpath=", "css=", "name=", "link=", "partialLink="});
    }

    public static By forPlace(String place) {
        return FirstNonNullHelper.firstNonNull(place, ID_BY, CSS_BY, NAME_BY, LINKTEXT_BY, PARTIALLINKTEXT_BY, XPATH_BY);
    }

    public static Function<String, By> byIfStartsWith(String prefix, Function<String, By> constr) {
        String prefixEq = prefix + "=";
        int prefixLength = prefixEq.length();
        return place -> place.startsWith(prefixEq) ? (By)constr.apply(place.substring(prefixLength)) : null;
    }
}

