/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.by;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.hsac.fitnesse.fixture.util.CacheHelper;
import nl.hsac.fitnesse.fixture.util.selenium.by.LazyPatternBy;
import org.openqa.selenium.By;

public class XPathBy
extends LazyPatternBy {
    private static final Map<String, String> CACHE = CacheHelper.lruCache(1000);
    private static final Pattern X_PATH_NORMALIZED = Pattern.compile("normalized\\((.+?(\\(\\))?)\\)");
    private static final String NBSP_CHAR = "\u00a0";
    private static final String NORMALIZED_REPLACEMENT = "normalize-space(translate($1, '\u00a0', ' '))";
    private static final Pattern WHITESPACE_REPLACE = Pattern.compile("[\u00a0\\s]+");

    public XPathBy(String pattern, String ... parameters) {
        super(pattern, parameters);
    }

    @Override
    protected By createNested(String expr) {
        return By.xpath((String)expr);
    }

    @Override
    protected String createExpression(String pattern, String ... parameters) {
        pattern = CACHE.computeIfAbsent(pattern, XPathBy::replaceNormalizedFunction);
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = XPathBy.replaceNormalizedFunction(parameters[i]);
        }
        String xpath = super.createExpression(pattern, parameters);
        return xpath;
    }

    private static String replaceNormalizedFunction(String xPath) {
        String result;
        if (xPath.contains("normalized(")) {
            String updatedPattern;
            Matcher m = X_PATH_NORMALIZED.matcher(xPath);
            result = updatedPattern = m.replaceAll(NORMALIZED_REPLACEMENT);
        } else {
            result = xPath;
        }
        return result;
    }

    public static String getNormalizedText(String elementText) {
        String result = null;
        if (elementText != null) {
            result = WHITESPACE_REPLACE.matcher(elementText).replaceAll(" ");
        }
        return result;
    }
}

