/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.by.grid;

import nl.hsac.fitnesse.fixture.util.selenium.by.GridBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.SingleElementOrNullBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.ValueOfBy;
import nl.hsac.fitnesse.fixture.util.selenium.by.XPathBy;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public abstract class Value
extends SingleElementOrNullBy {
    protected WebElement valueInRow(SearchContext context, String columnXPath, String requestedColumnName) {
        String requestedIndex = GridBy.getXPathForColumnIndex(requestedColumnName);
        return this.getValueByXPath(context, "%s[%s]", columnXPath, requestedIndex);
    }

    protected WebElement getValueByXPath(SearchContext context, String xpathPattern, String ... params) {
        XPathBy xPathBy = new XPathBy(xpathPattern, params);
        return new ValueOfBy(xPathBy).findElement(context);
    }

    public static class OfInRowWhereIs
    extends Value {
        private final String requestedColumnName;
        private final String selectOnColumn;
        private final String selectOnValue;

        public OfInRowWhereIs(String requestedColumnName, String selectOnValue, String selectOnColumn) {
            this.requestedColumnName = requestedColumnName;
            this.selectOnColumn = selectOnColumn;
            this.selectOnValue = selectOnValue;
        }

        public WebElement findElement(SearchContext context) {
            String columnXPath = GridBy.getXPathForColumnInRowByValueInOtherColumn(this.selectOnValue, this.selectOnColumn, this.requestedColumnName);
            return this.valueInRow(context, columnXPath, this.requestedColumnName);
        }
    }

    public static class OfInRowNumber
    extends Value {
        private final String requestedColumnName;
        private final int rowIndex;

        public OfInRowNumber(String requestedColumnName, int rowIndex) {
            this.requestedColumnName = requestedColumnName;
            this.rowIndex = rowIndex;
        }

        public WebElement findElement(SearchContext context) {
            String headerXPath = GridBy.getXPathForHeaderRowByHeaders(this.requestedColumnName, new String[0]);
            String columnXPath = String.format("((.//table[./%1$s])[last()]//tr[boolean(td)])[%2$s]/td", headerXPath, this.rowIndex);
            return this.valueInRow(context, columnXPath, this.requestedColumnName);
        }
    }

    public static class AtCoordinates
    extends Value {
        private final int columnIndex;
        private final int rowIndex;

        public AtCoordinates(int columnIndex, int rowIndex) {
            this.columnIndex = columnIndex;
            this.rowIndex = rowIndex;
        }

        public WebElement findElement(SearchContext context) {
            String row = Integer.toString(this.rowIndex);
            String column = Integer.toString(this.columnIndex);
            return this.getValueByXPath(context, "(.//tr[boolean(td)])[%s]/td[%s]", row, column);
        }
    }
}

