/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.caching;

import java.lang.invoke.MethodHandles;
import java.util.function.BooleanSupplier;
import nl.hsac.fitnesse.fixture.util.selenium.caching.Cache;
import nl.hsac.fitnesse.fixture.util.selenium.caching.ElementCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanCache
implements Cache<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final BooleanSupplier supplier;
    private boolean cachedValue;
    private long validUntil;

    public BooleanCache(BooleanSupplier supplier) {
        this.supplier = supplier;
    }

    public boolean getBooleanValue() {
        long start = ElementCache.getTime();
        if (this.validUntil < start) {
            LOGGER.trace("Cache miss");
            boolean newValue = this.getNewBooleanValue();
            this.setBooleanValue(newValue, ElementCache.getValidityEnd(start));
        } else {
            LOGGER.debug("Cache hit");
        }
        return this.cachedValue;
    }

    @Override
    public Boolean getNewValue() {
        return this.getNewBooleanValue();
    }

    @Override
    public Boolean getValue() {
        return this.cachedValue;
    }

    @Override
    public long getValidUntil() {
        return this.validUntil;
    }

    @Override
    public void setValue(Boolean value, long validUntil) {
        if (value == null) {
            this.validUntil = validUntil;
        } else {
            this.setBooleanValue(value, validUntil);
        }
    }

    public void setBooleanValue(boolean value, long validUntil) {
        this.cachedValue = value;
        this.validUntil = validUntil;
    }

    protected boolean getNewBooleanValue() {
        return this.supplier.getAsBoolean();
    }
}

