/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.caching;

import nl.hsac.fitnesse.fixture.util.selenium.caching.BooleanCache;
import nl.hsac.fitnesse.fixture.util.selenium.caching.ObjectCache;
import nl.hsac.fitnesse.fixture.util.selenium.caching.ObjectCacheMap;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.remote.RemoteWebElement;

public class CachingRemoteWebElement
extends RemoteWebElement {
    private BooleanCache isSelectedCache;
    private final BooleanCache isDisplayedCache = new BooleanCache(() -> super.isDisplayed());
    private BooleanCache isEnabledCache;
    private ObjectCache<String> tagNameCache;
    private ObjectCache<String> textCache;
    private ObjectCache<Point> locationCache;
    private ObjectCache<Dimension> sizeCache;
    private ObjectCache<Rectangle> rectCache;
    private ObjectCacheMap<String, String> attributesCache;
    private ObjectCacheMap<String, String> cssValuesCache;

    public CachingRemoteWebElement(RemoteWebElement element) {
        if (element != null) {
            this.setId(element.getId());
        }
    }

    public boolean isSelected() {
        if (this.isSelectedCache == null) {
            this.isSelectedCache = new BooleanCache(() -> super.isSelected());
        }
        return this.isSelectedCache.getBooleanValue();
    }

    public boolean isDisplayed() {
        return this.isDisplayedCache.getBooleanValue();
    }

    public boolean isEnabled() {
        if (this.isEnabledCache == null) {
            this.isEnabledCache = new BooleanCache(() -> super.isEnabled());
        }
        return this.isEnabledCache.getBooleanValue();
    }

    public String getTagName() {
        if (this.tagNameCache == null) {
            this.tagNameCache = new ObjectCache<String>(() -> super.getTagName());
        }
        return this.tagNameCache.getValue();
    }

    public String getText() {
        if (this.textCache == null) {
            this.textCache = new ObjectCache<String>(() -> super.getText());
        }
        return this.textCache.getValue();
    }

    public Point getLocation() {
        if (this.locationCache == null) {
            this.locationCache = new ObjectCache<Point>(() -> super.getLocation());
        }
        return this.locationCache.getValue();
    }

    public Dimension getSize() {
        if (this.sizeCache == null) {
            this.sizeCache = new ObjectCache<Dimension>(() -> super.getSize());
        }
        return this.sizeCache.getValue();
    }

    public Rectangle getRect() {
        if (this.rectCache == null) {
            this.rectCache = new ObjectCache<Rectangle>(() -> super.getRect());
        }
        return this.rectCache.getValue();
    }

    public String getAttribute(String name) {
        if (this.attributesCache == null) {
            this.attributesCache = new ObjectCacheMap<String, String>(x$0 -> super.getAttribute(x$0));
        }
        return this.attributesCache.getValue(name);
    }

    public String getCssValue(String propertyName) {
        if (this.cssValuesCache == null) {
            this.cssValuesCache = new ObjectCacheMap<String, String>(x$0 -> super.getCssValue(x$0));
        }
        return this.cssValuesCache.getValue(propertyName);
    }
}

