/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.caching;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static long maxCacheDuration = 500L;
    private static long minCacheDuration = 100L;
    private static int ageFactor = 3;

    public static long getTime() {
        return System.currentTimeMillis();
    }

    public static long getValidityEnd(long start) {
        long cacheDuration;
        long end = ElementCache.getTime();
        if (ageFactor > 0) {
            long duration = end - start;
            LOGGER.trace("Cache value obtained in: {} ms", (Object)duration);
            long autoAge = duration * (long)ageFactor;
            cacheDuration = Math.max(autoAge, minCacheDuration);
        } else {
            cacheDuration = maxCacheDuration;
        }
        LOGGER.debug("New element will be valid for: {} ms", (Object)cacheDuration);
        return end + cacheDuration;
    }

    public static void setMaxCacheDuration(long maxCacheDuration) {
        ElementCache.maxCacheDuration = maxCacheDuration;
    }

    public static long getMaxCacheDuration() {
        return maxCacheDuration;
    }

    public static int getAgeFactor() {
        return ageFactor;
    }

    public static void setAgeFactor(int ageFactor) {
        ElementCache.ageFactor = ageFactor;
    }

    public static long getMinCacheDuration() {
        return minCacheDuration;
    }

    public static void setMinCacheDuration(long minCacheDuration) {
        ElementCache.minCacheDuration = minCacheDuration;
    }
}

