/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.caching;

import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import nl.hsac.fitnesse.fixture.util.selenium.caching.Cache;
import nl.hsac.fitnesse.fixture.util.selenium.caching.ElementCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectCache<T>
implements Cache<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Supplier<? extends T> supplier;
    private T cachedValue;
    private long validUntil;

    public ObjectCache(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T getValue() {
        long start = ElementCache.getTime();
        if (this.validUntil < start) {
            LOGGER.trace("Cache miss");
            T newValue = this.getNewValue();
            this.setValue(newValue, ElementCache.getValidityEnd(start));
        } else {
            LOGGER.debug("Cache hit");
        }
        return this.cachedValue;
    }

    @Override
    public T getNewValue() {
        return this.supplier.get();
    }

    @Override
    public void setValue(T value, long validUntil) {
        this.cachedValue = value;
        this.validUntil = validUntil;
    }

    @Override
    public long getValidUntil() {
        return this.validUntil;
    }
}

