/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.caching;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import nl.hsac.fitnesse.fixture.util.selenium.caching.ObjectCache;

public class ObjectCacheMap<K, V> {
    private final Map<K, ObjectCache<V>> valuesCache = new HashMap<K, ObjectCache<V>>();
    private final Function<K, ObjectCache<V>> cacheCreationFunction = x -> new ObjectCache<Object>(() -> function.apply(x));

    public ObjectCacheMap(Function<K, V> function) {
    }

    public V getValue(K key) {
        return this.getObjectCache(key).getValue();
    }

    public void putAll(Map<K, V> newValues, long timestamp) {
        newValues.forEach((k, v) -> this.getObjectCache(k).setValue(v, timestamp));
    }

    public ObjectCache<V> getObjectCache(K key) {
        return this.valuesCache.computeIfAbsent(key, this.cacheCreationFunction);
    }

    public Map<K, ObjectCache<V>> getValuesCache() {
        return this.valuesCache;
    }
}

