/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.caching;

import nl.hsac.fitnesse.fixture.util.selenium.caching.CachingRemoteWebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

public class WebElementConverter
extends JsonToWebElementConverter {
    private final RemoteWebDriver driver;

    public WebElementConverter(RemoteWebDriver d) {
        super(d);
        this.driver = d;
    }

    public Object apply(Object result) {
        if (result instanceof RemoteWebElement && !(result instanceof CachingRemoteWebElement)) {
            RemoteWebElement originalElement = (RemoteWebElement)result;
            result = this.createCachingWebElement(originalElement);
        }
        return super.apply(result);
    }

    protected CachingRemoteWebElement newRemoteWebElement() {
        return this.createCachingWebElement(null);
    }

    protected CachingRemoteWebElement createCachingWebElement(RemoteWebElement originalElement) {
        CachingRemoteWebElement element = new CachingRemoteWebElement(originalElement);
        element.setParent(this.driver);
        element.setFileDetector(this.driver.getFileDetector());
        return element;
    }
}

