/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.driverfactory;

import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.slim.StopTestException;
import nl.hsac.fitnesse.fixture.util.selenium.SeleniumHelper;
import nl.hsac.fitnesse.fixture.util.selenium.by.BestMatchBy;
import nl.hsac.fitnesse.fixture.util.selenium.caching.WebElementConverter;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.DriverFactory;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

public class DriverManager {
    private static final int DEFAULT_TIMEOUT_SECONDS = 10;
    private DriverFactory factory;
    private int defaultTimeoutSeconds = 10;
    private SeleniumHelper helper;

    public DriverManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.closeDriver()));
    }

    public void setFactory(DriverFactory factory) {
        this.factory = factory;
    }

    public DriverFactory getFactory() {
        return this.factory;
    }

    public void closeDriver() {
        this.setSeleniumHelper(null);
    }

    public SeleniumHelper getSeleniumHelper() {
        if (this.helper == null) {
            DriverFactory currentFactory = this.getFactory();
            if (currentFactory == null) {
                throw new StopTestException("Cannot use Selenium before configuring how to start a driver (for instance using SeleniumDriverSetup)");
            }
            try {
                WebDriver driver = currentFactory.createDriver();
                this.postProcessDriver(driver);
                SeleniumHelper newHelper = this.createHelper(driver);
                newHelper.setWebDriver(driver, this.getDefaultTimeoutSeconds());
                this.setSeleniumHelper(newHelper);
            }
            catch (SessionNotCreatedException e) {
                throw new StopTestException(e.getMessage(), e);
            }
        }
        return this.helper;
    }

    private void postProcessDriver(WebDriver driver) {
        if (driver instanceof RemoteWebDriver) {
            this.setElementConverter((RemoteWebDriver)driver);
        }
    }

    public void setSeleniumHelper(SeleniumHelper helper) {
        if (this.helper != null) {
            this.helper.close();
        }
        this.helper = helper;
    }

    protected SeleniumHelper createHelper(WebDriver driver) {
        BestMatchBy.setBestFunction(BestMatchBy::selectBestElement);
        return new SeleniumHelper();
    }

    public int getDefaultTimeoutSeconds() {
        return this.defaultTimeoutSeconds;
    }

    public void setDefaultTimeoutSeconds(int defaultTimeoutSeconds) {
        this.defaultTimeoutSeconds = defaultTimeoutSeconds;
    }

    protected void setElementConverter(RemoteWebDriver d) {
        JsonToWebElementConverter converter = this.createElementConverter(d);
        Environment.getInstance().getReflectionHelper().setField(d, "converter", converter);
    }

    protected JsonToWebElementConverter createElementConverter(RemoteWebDriver d) {
        return new WebElementConverter(d);
    }
}

