/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.driverfactory;

import java.util.Map;
import nl.hsac.fitnesse.fixture.slim.SlimFixtureException;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.DriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class LocalDriverFactory
implements DriverFactory {
    private String driverClassName;
    private Class<? extends WebDriver> driverClass;
    private Map<String, Object> profile;

    protected LocalDriverFactory() {
    }

    public LocalDriverFactory(String driver, Map<String, Object> profile) {
        this.driverClassName = driver;
        this.profile = profile;
        this.getDriverClass();
    }

    @Override
    public WebDriver createDriver() {
        Class<?> driverClass = this.getDriverClass();
        try {
            Object driver;
            if ("firefoxdriver".equalsIgnoreCase(driverClass.getSimpleName())) {
                FirefoxProfile fxProfile = LocalDriverFactory.getFirefoxProfile(this.profile);
                FirefoxOptions options = new FirefoxOptions().setProfile(fxProfile);
                driver = new FirefoxDriver(options);
            } else if ("chromedriver".equalsIgnoreCase(driverClass.getSimpleName())) {
                DesiredCapabilities capabilities = LocalDriverFactory.getChromeMobileCapabilities(this.profile);
                DriverFactory.addDefaultCapabilities((MutableCapabilities)capabilities);
                driver = new ChromeDriver((Capabilities)capabilities);
            } else if ("internetexplorerdriver".equalsIgnoreCase(driverClass.getSimpleName())) {
                InternetExplorerOptions ieOptions = LocalDriverFactory.getInternetExplorerOptions(this.profile);
                driver = new InternetExplorerDriver(ieOptions);
            } else {
                driver = driverClass.newInstance();
            }
            return (WebDriver)driver;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Class<?> getDriverClass() {
        if (this.driverClass == null) {
            try {
                Class<?> driver = Class.forName(this.driverClassName);
                if (!WebDriver.class.isAssignableFrom(driver)) {
                    throw new SlimFixtureException(false, this.driverClassName + " does not implement " + WebDriver.class.getName());
                }
                this.driverClass = driver;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to create " + this.driverClassName, e);
            }
        }
        return this.driverClass;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setDriverClass(Class<? extends WebDriver> driverClass) {
        this.driverClass = driverClass;
    }

    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public static FirefoxProfile getFirefoxProfile(Map<String, Object> profile) {
        FirefoxProfile fxProfile = new FirefoxProfile();
        if (profile != null) {
            for (Map.Entry<String, Object> profileEntry : profile.entrySet()) {
                String key = profileEntry.getKey();
                Object value = profileEntry.getValue();
                if (value instanceof Boolean) {
                    fxProfile.setPreference(key, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value instanceof Integer) {
                    fxProfile.setPreference(key, ((Integer)value).intValue());
                    continue;
                }
                if (value == null) {
                    fxProfile.setPreference(key, null);
                    continue;
                }
                fxProfile.setPreference(key, value.toString());
            }
        }
        return fxProfile;
    }

    public static DesiredCapabilities getChromeMobileCapabilities(Map<String, Object> profile) {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        if (profile != null) {
            capabilities.setCapability("goog:chromeOptions", profile);
        }
        return capabilities;
    }

    public static InternetExplorerOptions getInternetExplorerOptions(Map<String, Object> profile) {
        InternetExplorerOptions ieOptions = new InternetExplorerOptions();
        if (profile != null) {
            for (Map.Entry<String, Object> profileEntry : profile.entrySet()) {
                ieOptions.setCapability(profileEntry.getKey(), profileEntry.getValue());
            }
        }
        return ieOptions;
    }
}

