/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.fixture.util.selenium.driverfactory;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.BiFunction;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.DriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UselessFileDetector;

public class RemoteDriverFactory<T extends RemoteWebDriver>
implements DriverFactory {
    public static final String REMOTE_URL_KEY = "SeleniumRemoteUrl";
    private final BiFunction<URL, Capabilities, T> constr;
    private final URL url;
    private final Capabilities capabilities;

    public RemoteDriverFactory(BiFunction<URL, Capabilities, T> constr, String url, Capabilities capabilities) {
        try {
            this.constr = constr;
            this.url = new URL(url);
            this.capabilities = capabilities;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public T createDriver() {
        RemoteWebDriver remoteWebDriver;
        FileDetector fd;
        if (this.capabilities instanceof MutableCapabilities) {
            DriverFactory.addDefaultCapabilities((MutableCapabilities)this.capabilities);
        }
        if ((fd = (remoteWebDriver = (RemoteWebDriver)this.constr.apply(this.url, this.capabilities)).getFileDetector()) == null || fd instanceof UselessFileDetector) {
            remoteWebDriver.setFileDetector((FileDetector)new LocalFileDetector());
        }
        Environment.getInstance().setSymbol(REMOTE_URL_KEY, this.url.toString());
        return (T)remoteWebDriver;
    }
}

