/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit;

import fitnesse.ContextConfigurator;
import fitnesse.FitNesseContext;
import fitnesse.components.PluginsClassLoaderFactory;
import fitnesse.junit.DescriptionFactory;
import fitnesse.junit.FitNesseRunner;
import fitnesse.reporting.RerunSuiteFormatter;
import fitnesse.testrunner.MultipleTestsRunner;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.slim.web.LayoutTest;
import nl.hsac.fitnesse.fixture.slim.web.SeleniumDriverSetup;
import nl.hsac.fitnesse.fixture.util.FileUtil;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.DriverFactory;
import nl.hsac.fitnesse.junit.selenium.LocalSeleniumDriverClassFactoryFactory;
import nl.hsac.fitnesse.junit.selenium.LocalSeleniumDriverFactoryFactory;
import nl.hsac.fitnesse.junit.selenium.SeleniumDriverFactoryFactory;
import nl.hsac.fitnesse.junit.selenium.SeleniumGridDriverFactoryFactory;
import nl.hsac.fitnesse.junit.selenium.SeleniumJsonGridDriverFactoryFactory;
import nl.hsac.fitnesse.junit.selenium.SimpleSeleniumGridDriverFactoryFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class HsacFitNesseRunner
extends FitNesseRunner {
    public static final String FITNESSE_RESULTS_PATH_OVERRIDE_VARIABLE_NAME = "fitnesseResultsDir";
    public static final String FITNESSE_RESULTS_PATH = "target/fitnesse-results";
    public static final String SUITE_OVERRIDE_VARIABLE_NAME = "fitnesseSuiteToRun";
    public static final String SUITE_FILTER_STRATEGY_OVERRIDE_VARIABLE_NAME = "suiteFilterStrategy";
    public static final String SUITE_FILTER_OVERRIDE_VARIABLE_NAME = "suiteFilter";
    public static final String EXCLUDE_SUITE_FILTER_OVERRIDE_VARIABLE_NAME = "excludeSuiteFilter";
    public static final String SELENIUM_DEFAULT_TIMEOUT_PROP = "seleniumDefaultTimeout";
    public static final String RE_RUN_SUITE_LOCATION_OVERRIDE_VARIABLE_NAME = "reRunSuiteLocation";
    protected final List<SeleniumDriverFactoryFactory> factoryFactories = new ArrayList<SeleniumDriverFactoryFactory>();

    public HsacFitNesseRunner(Class<?> suiteClass) throws InitializationError {
        super(suiteClass);
        try {
            this.factoryFactories.add(new SimpleSeleniumGridDriverFactoryFactory());
            this.factoryFactories.add(new SeleniumGridDriverFactoryFactory());
            this.factoryFactories.add(new SeleniumJsonGridDriverFactoryFactory());
            this.factoryFactories.add(new LocalSeleniumDriverFactoryFactory());
            this.factoryFactories.add(new LocalSeleniumDriverClassFactoryFactory());
            Environment environment = Environment.getInstance();
            String outputDir = this.getOutputDir(suiteClass);
            new File(outputDir).mkdirs();
            String fitNesseDir = this.getFitNesseDir(suiteClass);
            environment.setFitNesseDir(fitNesseDir);
            String srcRootDir = fitNesseDir + "/" + this.getFitNesseRoot(suiteClass);
            environment.setFitNesseRoot(srcRootDir);
            String srcFilesDir = environment.getFitNesseFilesSectionDir();
            environment.setFitNesseRoot(outputDir);
            String targetFilesDir = environment.getFitNesseFilesSectionDir();
            this.copyFilesToOutputDir(suiteClass, srcFilesDir, targetFilesDir);
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected void copyFilesToOutputDir(Class<?> suiteClass, String srcFilesDir, String targetFilesDir) throws IOException {
        File srcDir = new File(srcFilesDir);
        if (srcDir.exists()) {
            FileFilter fileSectionFilter = this.getFileSectionCopyFilter(suiteClass);
            FileUtils.copyDirectory((File)srcDir, (File)new File(targetFilesDir), (FileFilter)fileSectionFilter);
        }
    }

    protected FileFilter getFileSectionCopyFilter(Class<?> suiteClass) {
        List<String> excludes = this.getFileSectionCopyExcludes(suiteClass);
        ArrayList excludeFilters = new ArrayList(excludes.size());
        excludes.forEach(x -> excludeFilters.add(new WildcardFileFilter(x)));
        return new NotFileFilter((IOFileFilter)new OrFileFilter(excludeFilters));
    }

    protected List<String> getFileSectionCopyExcludes(Class<?> suiteClass) {
        List<String> excludes = FilesSectionCopy.DEFAULT_EXCLUDES;
        FilesSectionCopy fsAnn = suiteClass.getAnnotation(FilesSectionCopy.class);
        if (fsAnn != null) {
            excludes = new ArrayList<String>();
            String[] explicitExcludes = fsAnn.exclude();
            if (explicitExcludes.length > 0) {
                excludes.addAll(Arrays.asList(explicitExcludes));
            }
            if (fsAnn.addDefaultExcludes()) {
                excludes.addAll(FilesSectionCopy.DEFAULT_EXCLUDES);
            }
        }
        return excludes;
    }

    protected String getSuiteName(Class<?> klass) throws InitializationError {
        String name = System.getProperty(SUITE_OVERRIDE_VARIABLE_NAME);
        if (StringUtils.isEmpty((CharSequence)name)) {
            FitNesseRunner.Suite nameAnnotation = klass.getAnnotation(FitNesseRunner.Suite.class);
            if (nameAnnotation == null) {
                throw new InitializationError("There must be a @Suite annotation");
            }
            name = nameAnnotation.value();
        }
        return name;
    }

    protected String getFitNesseDir(Class<?> suiteClass) throws InitializationError {
        String dir = "wiki";
        if (suiteClass.isAnnotationPresent(FitNesseRunner.FitnesseDir.class)) {
            dir = super.getFitNesseDir(suiteClass);
        }
        return dir;
    }

    protected String getOutputDir(Class<?> klass) throws InitializationError {
        String dir = System.getProperty(FITNESSE_RESULTS_PATH_OVERRIDE_VARIABLE_NAME);
        if (StringUtils.isEmpty((CharSequence)dir)) {
            dir = FITNESSE_RESULTS_PATH;
            if (klass.isAnnotationPresent(FitNesseRunner.OutputDir.class)) {
                dir = super.getOutputDir(klass);
            }
        }
        return dir;
    }

    protected String getFitNesseRoot(Class<?> suiteClass) {
        String root = "FitNesseRoot";
        if (suiteClass.isAnnotationPresent(FitNesseRunner.FitnesseDir.class)) {
            root = super.getFitNesseRoot(suiteClass);
        }
        return root;
    }

    protected FitNesseContext createContext(Class<?> suiteClass) throws Exception {
        System.setProperty("fitnesse.wikitext.widgets.MavenClasspathSymbolType.Disable", "true");
        ClassLoader cl = PluginsClassLoaderFactory.getClassLoader((String)this.getFitNesseDir(suiteClass));
        ContextConfigurator configurator = this.initContextConfigurator().withClassLoader(cl);
        return configurator.makeFitNesseContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPages(List<WikiPage> pages, RunNotifier notifier) {
        boolean seleniumConfigOverridden = this.configureSeleniumIfNeeded();
        try {
            super.runPages(pages, notifier);
        }
        finally {
            if (seleniumConfigOverridden) {
                try {
                    this.shutdownSelenium();
                }
                catch (Exception e) {
                    System.err.println("Error shutting down selenium");
                    e.printStackTrace();
                }
            }
            try {
                String path;
                String overviewHtml;
                Class suiteClass = this.getTestClass().getJavaClass();
                String outputDir = this.getOutputDir(suiteClass);
                String suiteName = this.getSuiteName(suiteClass);
                String filename = suiteName + ".html";
                File overviewFile = new File(outputDir, filename);
                if (overviewFile.exists() && (overviewHtml = FileUtil.streamToString(new FileInputStream(path = overviewFile.getAbsolutePath()), path)) != null) {
                    String indexHtml = this.getIndexHtmlContent(overviewHtml);
                    FileUtil.writeFile(new File(outputDir, "index.html").getAbsolutePath(), indexHtml);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to create index.html for top level suite");
                e.printStackTrace();
            }
        }
    }

    protected void addTestSystemListeners(RunNotifier notifier, MultipleTestsRunner testRunner, Class<?> suiteClass, DescriptionFactory descriptionFactory) {
        super.addTestSystemListeners(notifier, testRunner, suiteClass, descriptionFactory);
        try {
            String fitNesseRootDir = this.getReRunSuiteLocation(suiteClass);
            testRunner.addTestSystemListener((TestSystemListener)new RerunSuiteFormatter(new File(fitNesseRootDir, "ReRunLastFailures.wiki")));
        }
        catch (Exception e) {
            System.err.println("Unable to create re-run suite generator: " + e);
        }
    }

    protected String getReRunSuiteLocation(Class<?> suiteClass) throws InitializationError {
        String reRunSuiteLocation = System.getProperty(RE_RUN_SUITE_LOCATION_OVERRIDE_VARIABLE_NAME);
        if (StringUtils.isEmpty((CharSequence)reRunSuiteLocation)) {
            reRunSuiteLocation = this.getFitNesseDir(suiteClass) + "/" + this.getFitNesseRoot(suiteClass);
        }
        return reRunSuiteLocation;
    }

    protected boolean getSuiteFilterAndStrategy(Class<?> klass) throws Exception {
        String strategy = System.getProperty(SUITE_FILTER_STRATEGY_OVERRIDE_VARIABLE_NAME);
        if (StringUtils.isEmpty((CharSequence)strategy)) {
            return super.getSuiteFilterAndStrategy(klass);
        }
        return strategy.equalsIgnoreCase("and");
    }

    protected String getSuiteFilter(Class<?> klass) throws Exception {
        String suiteFilter = System.getProperty(SUITE_FILTER_OVERRIDE_VARIABLE_NAME);
        if (StringUtils.isEmpty((CharSequence)suiteFilter)) {
            suiteFilter = super.getSuiteFilter(klass);
        }
        return suiteFilter;
    }

    protected String getExcludeSuiteFilter(Class<?> klass) throws Exception {
        String excludeSuiteFilter = System.getProperty(EXCLUDE_SUITE_FILTER_OVERRIDE_VARIABLE_NAME);
        if (StringUtils.isEmpty((CharSequence)excludeSuiteFilter)) {
            excludeSuiteFilter = super.getExcludeSuiteFilter(klass);
        }
        return excludeSuiteFilter;
    }

    protected boolean configureSeleniumIfNeeded() {
        this.setSeleniumDefaultTimeOut();
        try {
            DriverFactory factory = null;
            SeleniumDriverFactoryFactory factoryFactory = this.getSeleniumDriverFactoryFactory();
            if (factoryFactory != null && (factory = factoryFactory.getDriverFactory()) != null) {
                SeleniumDriverSetup.lockConfig();
                Environment.getInstance().getSeleniumDriverManager().setFactory(factory);
            }
            return factory != null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error overriding Selenium config", e);
        }
    }

    protected void setSeleniumDefaultTimeOut() {
        String propValue = System.getProperty(SELENIUM_DEFAULT_TIMEOUT_PROP);
        if (StringUtils.isNotEmpty((CharSequence)propValue)) {
            try {
                int timeoutSeconds = Integer.parseInt(propValue);
                Environment.getInstance().getSeleniumDriverManager().setDefaultTimeoutSeconds(timeoutSeconds);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Bad seleniumDefaultTimeout system property: " + propValue, e);
            }
        }
    }

    protected SeleniumDriverFactoryFactory getSeleniumDriverFactoryFactory() {
        SeleniumDriverFactoryFactory result = null;
        for (SeleniumDriverFactoryFactory factory : this.factoryFactories) {
            if (!factory.willOverride()) continue;
            result = factory;
            break;
        }
        return result;
    }

    protected void shutdownSelenium() {
        SeleniumDriverSetup.unlockConfig();
        new SeleniumDriverSetup().stopDriver();
    }

    protected String getIndexHtmlContent(String overviewHtml) {
        String result = overviewHtml;
        String runSummary = this.getRunSummary();
        if (!"".equals(runSummary)) {
            result = overviewHtml.replaceFirst("<table", runSummary + "<table");
        }
        return result;
    }

    protected String getRunSummary() {
        String galenReport;
        String runSummary = "";
        String seleniumSummary = SeleniumDriverSetup.getLastRunSummary();
        if (seleniumSummary != null) {
            runSummary = runSummary + seleniumSummary;
        }
        if ((galenReport = LayoutTest.getOverallReportLink()) != null) {
            runSummary = runSummary + galenReport;
        }
        return runSummary;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FilesSectionCopy {
        public static final List<String> DEFAULT_EXCLUDES = Arrays.asList("testResults", "testProgress", "screenshots", "pagesources", "downloads", "galen-reports", "fileFixture", "test", "galenExamples", "httpPostExamples", "Desktop.ini", ".DS_Store", ".svn");

        public String[] exclude() default {};

        public boolean addDefaultExcludes() default true;
    }
}

