/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.hsac.fitnesse.junit.JUnitXMLPerPageListener;
import nl.hsac.fitnesse.junit.ProgressLoggerListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public class JUnitConsoleRunner {
    protected List<RunListener> getListeners() {
        return Arrays.asList(new RunListener[]{new JUnitXMLPerPageListener(), new ProgressLoggerListener()});
    }

    protected List<Class> getTestClasses(String[] args) {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (String arg : args) {
            try {
                classes.add(Class.forName(arg));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to create instance of: " + arg);
            }
        }
        return classes;
    }

    public Result runTests(String ... args) {
        JUnitCore core = new JUnitCore();
        for (RunListener r : this.getListeners()) {
            core.addListener(r);
        }
        List<Class> classes = this.getTestClasses(args);
        return core.run(classes.toArray(new Class[classes.size()]));
    }

    public static void main(String[] args) {
        Result r;
        if (args.length == 0) {
            System.err.println("No test class names provided as argument.");
            System.exit(-1);
        }
        System.exit((r = new JUnitConsoleRunner().runTests(args)).wasSuccessful() ? 0 : 1);
    }
}

