/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit;

import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitTeamcityReporter
extends RunListener {
    private final PrintStream out;
    private final String flowId = ManagementFactory.getRuntimeMXBean().getName();
    private String currentTestClassName = null;

    public JUnitTeamcityReporter() {
        this(System.out);
    }

    public JUnitTeamcityReporter(PrintStream out) {
        this.out = out;
        this.currentTestClassName = null;
    }

    public void testStarted(Description description) {
        String testClassName = this.getTestClassName(description);
        String testName = this.getTestName(description);
        if (this.currentTestClassName == null || !this.currentTestClassName.equals(testClassName)) {
            this.testRunFinished(null);
            this.println("##teamcity[testSuiteStarted flowId='%s' name='%s']", this.flowId, testClassName);
            this.currentTestClassName = testClassName;
        }
        this.println("##teamcity[testStarted flowId='%s' name='%s' captureStandardOutput='true']", this.flowId, testName);
    }

    public void testFinished(Description description) {
        String testName = this.getTestName(description);
        this.println("##teamcity[testFinished flowId='%s' name='%s']", this.flowId, testName);
    }

    public void testFailure(Failure failure) {
        if (failure.getTrace() != null && !failure.getTrace().isEmpty()) {
            this.print(failure.getTrace());
        }
        this.println("##teamcity[testFailed flowId='%s' name='%s' message='%s' details='%s']", this.flowId, this.getTestName(failure.getDescription()), "failed", "");
        this.testFinished(failure.getDescription());
    }

    public void testIgnored(Description description) {
        this.println("##teamcity[testIgnored flowId='%s' name='%s' message='%s']", this.flowId, this.getTestName(description), "");
    }

    public void testRunFinished(Result result) {
        if (this.currentTestClassName != null) {
            this.println("##teamcity[testSuiteFinished flowId='%s' name='%s']", this.flowId, this.currentTestClassName);
        }
    }

    protected String getTestClassName(Description description) {
        return description.getTestClass().getName();
    }

    protected String getTestName(Description description) {
        return description.getMethodName();
    }

    private void println(String pattern, Object ... args) {
        String msg = String.format(pattern, args);
        this.out.println(msg);
    }

    private void print(String msg) {
        this.out.print(msg);
    }
}

