/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit;

import fitnesse.util.TimeMeasurement;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.text.StringEscapeUtils;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnitXMLPerPageListener
extends RunListener {
    private static final String OUTPUT_PATH = "target/failsafe-reports/";
    private TimeMeasurement timeMeasurement;

    public JUnitXMLPerPageListener() {
        new File(this.getOutputPath()).mkdirs();
    }

    public void testStarted(Description description) throws Exception {
        this.timeMeasurement = new TimeMeasurement().start();
        super.testStarted(description);
    }

    public void testFinished(Description description) throws Exception {
        super.testFinished(description);
        if (!this.timeMeasurement.isStopped()) {
            this.recordTestResult(description, null, this.getExecutionTime());
        }
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        this.recordTestResult(failure.getDescription(), failure.getException(), this.getExecutionTime());
    }

    protected double getExecutionTime() {
        double executionTime = 0.0;
        if (this.timeMeasurement != null) {
            executionTime = this.timeMeasurement.elapsedSeconds();
            if (!this.timeMeasurement.isStopped()) {
                this.timeMeasurement.stop();
            }
        }
        return executionTime;
    }

    protected void recordTestResult(Description description, Throwable exception, double executionTime) throws IOException {
        String testName = this.getTestName(description);
        String resultXml = this.generateResultXml(testName, exception, executionTime);
        this.writeResult(testName, resultXml);
    }

    protected String generateResultXml(String testName, Throwable exception, double executionTime) {
        int errors = 0;
        int failures = 0;
        String failureXml = "";
        if (exception != null) {
            failureXml = "<failure type=\"" + exception.getClass().getName() + "\" message=\"" + this.getMessage(exception) + "\"></failure>";
            if (exception instanceof AssertionError) {
                failures = 1;
            } else {
                errors = 1;
            }
        }
        return "<testsuite errors=\"" + errors + "\" skipped=\"0\" tests=\"1\" time=\"" + executionTime + "\" failures=\"" + failures + "\" name=\"" + testName + "\"><properties></properties><testcase classname=\"" + testName + "\" time=\"" + executionTime + "\" name=\"" + testName + "\">" + failureXml + "</testcase></testsuite>";
    }

    protected String getMessage(Throwable exception) {
        String errorMessage = exception.getMessage();
        return StringEscapeUtils.escapeXml10((String)errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResult(String testName, String resultXml) throws IOException {
        String finalPath = this.getXmlFileName(testName);
        try (Writer fw = null;){
            fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(finalPath), "UTF-8"));
            fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fw.write(resultXml);
        }
    }

    protected String getXmlFileName(String testName) {
        return new File(this.getOutputPath(), "TEST-" + testName + ".xml").getAbsolutePath();
    }

    protected String getOutputPath() {
        return OUTPUT_PATH;
    }

    protected String getTestName(Description description) {
        return description.getMethodName();
    }
}

