/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class ProgressLoggerListener
extends RunListener {
    private final PrintStream out;
    private String currentTestClassName = null;
    private SimpleDateFormat formatter;
    private int totalChildCount;
    private int currentChild;

    public ProgressLoggerListener() {
        this(System.out);
    }

    public ProgressLoggerListener(PrintStream out) {
        this.out = out;
        this.currentTestClassName = null;
        this.formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ");
        this.totalChildCount = 0;
        this.currentChild = 0;
    }

    public void testRunStarted(Description description) throws Exception {
        super.testRunStarted(description);
        this.totalChildCount = this.totalChildCount(description);
        this.currentChild = 0;
        this.report("testRun Started ('%s' tests)", this.totalChildCount);
    }

    private int totalChildCount(Description description) {
        int count = 0;
        if (description != null) {
            count = description.testCount();
        }
        return count;
    }

    public void testStarted(Description description) throws Exception {
        String testClassName = this.getTestClassName(description);
        String testName = this.getTestName(description);
        if (this.currentTestClassName == null || !this.currentTestClassName.equals(testClassName)) {
            this.testRunFinished(null);
            this.report("testSuite Started '%s'", testClassName);
            this.currentTestClassName = testClassName;
        }
        if (testName == null || !testName.endsWith(".SuiteSetUp") && !testName.endsWith(".SuiteTearDown")) {
            ++this.currentChild;
        }
        this.report("test Started '%s' (%s / %s)", testName, this.currentChild, this.totalChildCount);
    }

    public void testFinished(Description description) throws Exception {
        String testName = this.getTestName(description);
        this.report("test Finished '%s'\n", testName);
    }

    public void testFailure(Failure failure) throws Exception {
        String trace = "";
        if (failure.getTrace() != null && !failure.getTrace().isEmpty()) {
            trace = failure.getTrace();
        }
        this.report("test Failed '%s' message='%s' details='%s'", this.getTestName(failure.getDescription()), "failed", trace);
        this.testFinished(failure.getDescription());
    }

    public void testIgnored(Description description) throws Exception {
        this.report("test Ignored '%s'", this.getTestName(description));
    }

    public void testRunFinished(Result result) throws Exception {
        if (this.currentTestClassName != null) {
            this.report("testSuite Finished '%s'\n\n", this.currentTestClassName);
        }
    }

    protected void report(String pattern, Object ... parameters) {
        this.out.print(this.formatter.format(new Date()));
        this.out.println(String.format(pattern, parameters));
    }

    protected String getTestName(Description description) {
        return description.getMethodName();
    }

    protected String getTestClassName(Description description) {
        return description.getTestClass().getName();
    }

    public void setFormatter(SimpleDateFormat formatter) {
        this.formatter = formatter;
    }
}

