/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.reportmerge;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import nl.hsac.fitnesse.fixture.util.FileUtil;
import nl.hsac.fitnesse.junit.reportmerge.ReportFinder;
import nl.hsac.fitnesse.junit.reportmerge.TestReportHtml;
import nl.hsac.fitnesse.junit.reportmerge.writer.CsvOverviewFileWriter;
import nl.hsac.fitnesse.junit.reportmerge.writer.HtmlOverviewFileWriter;
import nl.hsac.fitnesse.junit.reportmerge.writer.JsonOverviewFileWriter;
import nl.hsac.fitnesse.junit.reportmerge.writer.JsonWriter;

public class HtmlReportIndexGenerator {
    public static void main(String[] arguments) throws IOException {
        String path = "target/fitnesse-results";
        String target = null;
        if (arguments != null && arguments.length > 0) {
            path = arguments[0];
            if (arguments.length > 1) {
                target = arguments[1];
            }
        }
        System.out.println("Generating based on: " + path);
        String output = new HtmlReportIndexGenerator().createFrom(path, target);
        System.out.println("Generated overview: " + output);
    }

    public String createFrom(String path, String target) throws IOException {
        List<TestReportHtml> reportHtmls;
        File parentDir = new File(path);
        if (!parentDir.exists() || !parentDir.isDirectory()) {
            throw new IllegalArgumentException(parentDir.getAbsolutePath() + " is not an existing directory");
        }
        if (target != null) {
            FileUtil.copyTree(path, target);
            parentDir = new File(target);
        }
        if ((reportHtmls = this.findTestResultPages(parentDir)).isEmpty()) {
            throw new IllegalArgumentException("No results found below: " + parentDir.getAbsolutePath());
        }
        return this.createOverviewFiles(parentDir, reportHtmls);
    }

    protected List<TestReportHtml> findTestResultPages(File parentDir) throws IOException {
        return new ReportFinder().findTestResultPages(parentDir);
    }

    protected String createOverviewFiles(File parentDir, List<TestReportHtml> reportHtmls) throws IOException {
        Collections.sort(reportHtmls);
        this.createJsonOverviewFile(parentDir, reportHtmls);
        this.createCsvOverviewFile(parentDir, reportHtmls);
        return this.createHtmlOverviewFile(parentDir, reportHtmls);
    }

    protected String createJsonOverviewFile(File parentDir, List<TestReportHtml> reportHtmls) throws IOException {
        return new JsonOverviewFileWriter(parentDir, this::createJsonWriter).write(reportHtmls);
    }

    protected JsonWriter createJsonWriter(PrintWriter pw) {
        return new JsonWriter(pw);
    }

    protected String createCsvOverviewFile(File parentDir, List<TestReportHtml> reportHtmls) throws IOException {
        return new CsvOverviewFileWriter(parentDir).write(reportHtmls);
    }

    protected String createHtmlOverviewFile(File parentDir, List<TestReportHtml> htmls) throws IOException {
        return new HtmlOverviewFileWriter(parentDir, this::createJsonWriter).write(htmls);
    }
}

