/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.reportmerge;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.hsac.fitnesse.junit.reportmerge.TestReportFactory;
import nl.hsac.fitnesse.junit.reportmerge.TestReportHtml;

public class ReportFinder {
    public List<TestReportHtml> findTestResultPages(File parentDir) throws IOException {
        TestReportFactory reportFactory = this.getReportFactory(parentDir);
        try (Stream<Path> htmlStream = Files.find(parentDir.toPath(), 2, (p, attributes) -> p.getFileName().toString().endsWith(".html"), new FileVisitOption[0]);){
            List<TestReportHtml> reportHtmls = htmlStream.filter(this::isNotIndexHtml).map(reportFactory::create).collect(Collectors.toList());
            this.postProcessReports(reportFactory, reportHtmls);
            List<TestReportHtml> list = reportHtmls;
            return list;
        }
    }

    protected boolean isNotIndexHtml(Path file) {
        return !"index.html".equals(file.getFileName().toString());
    }

    protected void postProcessReports(TestReportFactory reportFactory, List<TestReportHtml> reportHtmls) {
        for (TestReportHtml html : reportHtmls) {
            long time;
            int index;
            String runName = html.getRunName();
            if (html.isOverviewPage()) {
                index = reportFactory.getIndex(runName);
                time = reportFactory.getTime(runName);
            } else {
                String testName = html.getTestName();
                index = reportFactory.getIndex(runName, testName);
                time = reportFactory.getTime(runName, testName);
            }
            html.setTime(time);
            html.setIndex(index);
        }
    }

    protected TestReportFactory getReportFactory(File parentDir) {
        return new TestReportFactory(parentDir);
    }
}

