/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.reportmerge;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.hsac.fitnesse.fixture.util.FileUtil;
import nl.hsac.fitnesse.junit.reportmerge.TestReportHtml;

public class TestReportFactory {
    protected static final String OVERVIEW_TABLE_START = "<table><tr><td>Name</td><td>Right</td><td>Wrong</td><td>Exceptions</td><td>Runtime (in milliseconds)</td></tr>";
    protected static final Pattern TIME_PATTERN = Pattern.compile("</tr><tr class=.*?><td><a .*?>(.+?)</a></td><td>.+?</td><td>.+?</td><td>.+?</td><td>(\\d+?)</td>");
    protected final File rootDir;
    protected final Map<String, Map<String, Long>> testTimes = new HashMap<String, Map<String, Long>>();
    protected final Map<String, Map<String, Integer>> testIndexes = new HashMap<String, Map<String, Integer>>();

    public TestReportFactory(File rootDir) {
        this.rootDir = rootDir;
    }

    public TestReportHtml create(Path reportPath) {
        String status;
        File reportFile = reportPath.toFile();
        String content = TestReportFactory.getFileContent(reportFile);
        boolean isOverview = content.contains(OVERVIEW_TABLE_START);
        TestReportHtml reportHtml = new TestReportHtml(this.rootDir, reportPath, isOverview, status = this.getStatus(content));
        if (reportHtml.isOverviewPage()) {
            Map<String, Long> runTimes = this.getRunTimes(reportHtml, content);
            this.testTimes.put(reportHtml.getRunName(), runTimes);
            this.computeRunIndexes(reportHtml.getRunName(), runTimes);
        }
        return reportHtml;
    }

    public long getTime(String run) {
        return this.getTestTimes(run).values().stream().reduce(0L, Long::sum);
    }

    public long getTime(String run, String page) {
        Long time = this.getTestTimes(run).get(page);
        if (time == null) {
            time = -1L;
        }
        return time;
    }

    protected Map<String, Long> getTestTimes(String run) {
        return this.testTimes.computeIfAbsent(run, x -> Collections.emptyMap());
    }

    protected void computeRunIndexes(String run, Map<String, Long> runTimes) {
        int index = 0;
        Map<String, Integer> runIndexes = this.getTestIndexes(run);
        for (String page : runTimes.keySet()) {
            runIndexes.put(page, index++);
        }
    }

    public int getIndex(String run) {
        return Integer.MAX_VALUE;
    }

    public int getIndex(String run, String page) {
        return this.getTestIndexes(run).computeIfAbsent(page, p -> {
            int offset = 2;
            if (page.endsWith(".SuiteSetUp")) {
                offset = 3;
            } else if (page.endsWith(".SuiteTearDown")) {
                offset = 1;
            }
            return this.getIndex(run) - offset;
        });
    }

    protected Map<String, Integer> getTestIndexes(String run) {
        return this.testIndexes.computeIfAbsent(run, x -> new HashMap());
    }

    protected String getStatus(String content) {
        String result = content.contains("class=\"error\">") ? "error" : (content.contains("class=\"fail\">") ? "fail" : (content.contains("class=\"pass\">") ? "pass" : (content.contains("class=\"ignore\">") ? "ignore" : "no-test")));
        return result;
    }

    protected Map<String, Long> getRunTimes(TestReportHtml reportHtml, String content) {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        Matcher m = TIME_PATTERN.matcher(content);
        while (m.find()) {
            String name = m.group(1);
            String time = m.group(2);
            Long msTime = Long.valueOf(time);
            result.put(name, msTime);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String getFileContent(File file) {
        try (FileInputStream s = new FileInputStream(file);){
            String string = FileUtil.streamToString(s, file.getName()).trim();
            return string;
        }
        catch (IOException e) {
            return "";
        }
    }
}

