/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.reportmerge;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Date;

public class TestReportHtml
implements Comparable<TestReportHtml> {
    public static final String ERROR_STATUS = "error";
    public static final String FAIL_STATUS = "fail";
    public static final String PASS_STATUS = "pass";
    public static final String IGNORE_STATUS = "ignore";
    public static final String NO_TEST_STATUS = "no-test";
    private final Path htmlFilePath;
    private final FileTime fileTime;
    private final String relativePath;
    private final boolean isOverviewPage;
    private final String status;
    private long time = -2L;
    private int index = Integer.MAX_VALUE;

    public TestReportHtml(File parentDir, Path htmlFilePath, boolean isOverviewPage, String status) {
        this.htmlFilePath = htmlFilePath;
        this.isOverviewPage = isOverviewPage;
        this.status = status;
        this.relativePath = this.getRelativePath(parentDir);
        this.fileTime = this.determineTime(htmlFilePath);
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getRunName() {
        return this.getDirectory();
    }

    public String getDirectory() {
        return this.splitPageName(this.relativePath)[0];
    }

    public String getTestName() {
        return this.splitPageName(this.relativePath)[1].replace(".html", "");
    }

    protected String[] splitPageName(String testPageName) {
        String[] split = testPageName.split("/");
        if (split.length == 1) {
            split = new String[]{"", testPageName};
        }
        return split;
    }

    protected String getRelativePath(File parentDir) {
        return parentDir.toURI().relativize(this.getHtmlFile().toURI()).toString();
    }

    protected FileTime determineTime(Path path) {
        FileTime result = FileTime.fromMillis(0L);
        try {
            BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            FileTime creationTime = attributes.creationTime();
            result = creationTime.equals(result) ? attributes.lastModifiedTime() : creationTime;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    protected File getHtmlFile() {
        return this.htmlFilePath.toFile();
    }

    protected FileTime getFileTime() {
        return this.fileTime;
    }

    public Date getTimestamp() {
        return new Date(this.fileTime.toMillis());
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isOverviewPage() {
        return this.isOverviewPage;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String toString() {
        return this.getRunName() + " " + (this.isOverviewPage() ? "overview" : this.getTestName());
    }

    @Override
    public int compareTo(TestReportHtml other) {
        int result = this.getFileTime().compareTo(other.getFileTime());
        if (result == 0 && (result = this.getRunName().compareTo(other.getRunName())) == 0) {
            result = this.getIndex() - other.getIndex();
        }
        return result;
    }
}

