/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.reportmerge.writer;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class ChartWriter {
    protected final PrintWriter pw;

    public ChartWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public void writeLoadScriptTag() {
        this.pw.write("<script type='text/javascript' src='https://www.gstatic.com/charts/loader.js'></script>");
    }

    public <T> void writeChartGenerators(List<T> htmls, BiConsumer<ChartWriter, List<T>> bodyFunction, String extraJs, String ... chartElements) {
        this.pw.write("<script type='text/javascript'>");
        for (String elementToHide : chartElements) {
            this.writeVariableForElement(elementToHide);
            this.writeHideElement(elementToHide);
        }
        this.pw.write("if(window.google){");
        this.writeLoadAndCallback(htmls, bodyFunction);
        this.pw.write(extraJs);
        this.pw.write("}</script>");
    }

    public <T> void writePieChartGenerator(String title, String chartId, List<T> values, Function<T, String> keyFunction, Collector<T, ?, Long> groupValueCollector) {
        List<Map.Entry> sums = ChartWriter.sortBy(values.stream().collect(Collectors.groupingBy(keyFunction, groupValueCollector)).entrySet(), r -> (String)r.getKey());
        this.writePieChartGenerator(title, chartId, "", r -> (String)r.getKey(), r -> (Long)r.getValue(), sums);
    }

    public <T> void writePieChartGenerator(String title, String chartElementId, String extraOptions, Function<T, String> keyFunction, Function<T, Object> valueFunction, Iterable<T> groups) {
        String dataArray = this.createDataArray("'Group',''", keyFunction, valueFunction, groups);
        this.pw.write("var ");
        this.pw.write(chartElementId);
        this.pw.write("Data = google.visualization.arrayToDataTable(");
        this.pw.write(dataArray);
        this.pw.write(");");
        this.pw.write("var ");
        this.pw.write(chartElementId);
        this.pw.write("Chart = new google.visualization.PieChart(document.getElementById('");
        this.pw.write(chartElementId);
        this.pw.write("'));");
        this.pw.write(chartElementId);
        this.pw.write("Chart.draw(");
        this.pw.write(chartElementId);
        this.pw.write("Data");
        this.pw.write(",{title:'");
        this.pw.write(title);
        this.pw.write("',sliceVisibilityThreshold:0,is3D:true,pieSliceTextStyle:{color:'black'}");
        this.pw.write(extraOptions);
        this.pw.write("});");
    }

    public <T> void writeBarChartGenerator(Consumer<PrintWriter> testResultsWriter, String title, String chartElementId, String extraOptions) {
        this.pw.write("var testResults=");
        testResultsWriter.accept(this.pw);
        this.pw.write(";");
        this.writeUnhideElement(chartElementId);
        this.writeBarChartContentGenerator(title, chartElementId, extraOptions);
    }

    protected <T> void writeLoadAndCallback(List<T> htmls, BiConsumer<ChartWriter, List<T>> bodyFunction) {
        this.pw.write("google.charts.load('current',{'packages':['corechart']});");
        this.pw.write("google.charts.setOnLoadCallback(drawChart);");
        this.pw.write("function drawChart(){");
        bodyFunction.accept(this, htmls);
        this.pw.write("};");
    }

    protected void writeHideElement(String chartElementId) {
        this.pw.write("var ");
        this.pw.write(chartElementId);
        this.pw.write("CurrentStyle = ");
        this.pw.write(chartElementId);
        this.pw.write("Element.getAttribute('style');");
        this.pw.write(chartElementId);
        this.pw.write("Element.setAttribute('style', 'display: none;');");
    }

    protected void writeVariableForElement(String chartElementId) {
        this.pw.write("var ");
        this.pw.write(chartElementId);
        this.pw.write("Element = document.getElementById('");
        this.pw.write(chartElementId);
        this.pw.write("');");
    }

    protected void writeUnhideElement(String chartElementId) {
        this.pw.write(chartElementId);
        this.pw.write("Element.setAttribute('style', ");
        this.pw.write(chartElementId);
        this.pw.write("CurrentStyle);");
    }

    protected void writeBarChartContentGenerator(String title, String chartElementId, String extraOptions) {
        this.pw.write("var ");
        this.pw.write(chartElementId);
        this.pw.write("Array = [['Test','Runtime (ms)']];");
        this.pw.write("var ");
        this.pw.write(chartElementId);
        this.pw.write("Urls = [];");
        this.pw.write("for (var index = 0; index < testResults.length; ++index) {");
        this.pw.write("var testResult = testResults[index];");
        this.pw.write("if (!testResult.overviewPage) {");
        this.pw.write(chartElementId);
        this.pw.write("Array.push([testResult.testName, testResult.time]);");
        this.pw.write(chartElementId);
        this.pw.write("Urls.push(testResult.relativePath);");
        this.pw.write("}}");
        this.pw.write("testResults = null;");
        this.pw.write("var ");
        this.pw.write(chartElementId);
        this.pw.write("Data = google.visualization.arrayToDataTable(");
        this.pw.write(chartElementId);
        this.pw.write("Array);");
        this.pw.write(chartElementId);
        this.pw.write("Array = null;");
        this.pw.write("var ");
        this.pw.write(chartElementId);
        this.pw.write("Chart = new google.visualization.ColumnChart(");
        this.pw.write(chartElementId);
        this.pw.write("Element);");
        this.pw.write(chartElementId);
        this.pw.write("Chart.draw(");
        this.pw.write(chartElementId);
        this.pw.write("Data");
        this.pw.write(",{title:'");
        this.pw.write(title);
        this.pw.write("',bar: {groupWidth: '80%'},legend:{position: 'none'}");
        this.pw.write(extraOptions);
        this.pw.write("});");
        this.pw.write(chartElementId);
        this.pw.write("Data = null;");
        this.writeColumnClickListener(chartElementId);
    }

    protected void writeColumnClickListener(String chartElementId) {
        this.pw.write("google.visualization.events.addListener(");
        this.pw.write(chartElementId);
        this.pw.write("Chart,'select',function myClickHandler(event) {");
        this.pw.write("var selection = ");
        this.pw.write(chartElementId);
        this.pw.write("Chart.getSelection();");
        this.pw.write("for (var i = 0; i < selection.length; i++) {");
        this.pw.write("var item = selection[i];");
        this.pw.write("if (item.row != null && item.column != null) {");
        this.pw.write("window.location=");
        this.pw.write(chartElementId);
        this.pw.write("Urls[item.row];");
        this.pw.write("}}});");
    }

    protected <T> String createDataArray(String firstElement, Function<T, String> keyFunction, Function<T, Object> valueFunction, Iterable<T> groups) {
        StringBuilder data = new StringBuilder("[[");
        data.append(firstElement);
        data.append("],");
        groups.forEach(r -> {
            data.append("['");
            data.append((String)keyFunction.apply(r));
            data.append("',");
            data.append(valueFunction.apply(r));
            data.append("],");
        });
        data.append("]");
        return data.toString();
    }

    protected static <T> List<T> sortBy(Collection<T> values, Function<T, ? extends Comparable> function) {
        return values.stream().sorted((o1, o2) -> ((Comparable)function.apply(o1)).compareTo(function.apply(o2))).collect(Collectors.toList());
    }
}

