/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.reportmerge.writer;

import java.io.File;
import java.util.List;
import nl.hsac.fitnesse.junit.reportmerge.TestReportHtml;
import nl.hsac.fitnesse.junit.reportmerge.writer.OverviewFileWriter;

public class CsvOverviewFileWriter
extends OverviewFileWriter {
    private String fieldSeparator = "\t";

    public CsvOverviewFileWriter(File parentDir) {
        super(parentDir, "test-results.csv");
    }

    @Override
    protected void writeContent(List<TestReportHtml> reports) {
        this.writeHeader();
        this.writeLineEnd();
        for (TestReportHtml report : reports) {
            this.writeRow(report);
            this.writeLineEnd();
        }
    }

    protected void writeHeader() {
        this.pw.write("Run name");
        this.appendField("Test name");
        this.appendField("Is overview");
        this.appendField("Status");
        this.appendField("Runtime (in milliseconds)");
        this.appendField("Relative Path");
    }

    protected void writeRow(TestReportHtml report) {
        this.pw.write(report.getRunName());
        this.appendField(report.getTestName());
        this.appendField(Boolean.toString(report.isOverviewPage()));
        this.appendField(report.getStatus());
        this.appendField(report.getTime() < 0L ? "unknown" : Long.toString(report.getTime()));
        this.appendField(report.getRelativePath());
    }

    protected void appendField(String value) {
        this.pw.write(this.getFieldSeparator());
        this.pw.write(value);
    }

    protected void writeLineEnd() {
        this.pw.write("\n");
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }
}

