/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.reportmerge.writer;

import java.io.File;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nl.hsac.fitnesse.junit.reportmerge.TestReportHtml;
import nl.hsac.fitnesse.junit.reportmerge.writer.ChartWriter;
import nl.hsac.fitnesse.junit.reportmerge.writer.JsonWriter;
import nl.hsac.fitnesse.junit.reportmerge.writer.OverviewFileWriter;

public class HtmlOverviewFileWriter
extends OverviewFileWriter {
    private static final String TESTCOUNT_CHART_ID = "countPie";
    private static final String RUNTIME_CHART_ID = "runtimePie";
    private static final String STATUS_CHART_ID = "statusPie";
    private static final String TIME_PER_TEST_CHART_ID = "timePerTestChart";
    private static final String COPY_TO_CLIPBOARD_JS = "function elementContentsToClipboard(el) {var selected = document.getSelection().rangeCount > 0? document.getSelection().getRangeAt(0):false;var body = document.body, range, sel;if (document.createRange && window.getSelection) {range = document.createRange();sel = window.getSelection();sel.removeAllRanges();try {range.selectNodeContents(el);sel.addRange(range);} catch (e) {range.selectNode(el);sel.addRange(range);}document.execCommand('copy');} else if (body.createTextRange) {range = body.createTextRange();range.moveToElementText(el);range.select();range.execCommand('copy');}document.getSelection().removeAllRanges();if (selected) document.getSelection().addRange(selected);}";
    private final NumberFormat nf = NumberFormat.getIntegerInstance();
    protected Function<PrintWriter, JsonWriter> jsonWriterFunction;

    public HtmlOverviewFileWriter(File parentDir, Function<PrintWriter, JsonWriter> jsonWriterFunction) {
        super(parentDir, "index.html");
        this.jsonWriterFunction = jsonWriterFunction;
    }

    @Override
    protected void writeContent(List<TestReportHtml> htmls) {
        this.writeHeader(this.pw, htmls);
        this.writeBody(this.pw, htmls);
        this.writeFooter(this.pw, htmls);
    }

    protected void writeHeader(PrintWriter pw, List<TestReportHtml> htmls) {
        pw.write("<html><head><meta http-equiv='Content-Type' content='text/html;charset=UTF-8'/>");
        this.writeCssLink(pw, htmls);
        pw.write("<script type='text/javascript'>");
        pw.write(COPY_TO_CLIPBOARD_JS);
        pw.write("</script>");
        this.writeExtraHeaderContent(pw, htmls);
        pw.write("</head><body>");
    }

    protected void writeCssLink(PrintWriter pw, List<TestReportHtml> htmls) {
        pw.write("<link rel='stylesheet' type='text/css' href='");
        TestReportHtml firstTestPage = htmls.get(0);
        String firstRunCssDir = firstTestPage.getDirectory();
        if (!"".equals(firstRunCssDir)) {
            pw.write(firstRunCssDir);
            pw.write(47);
        }
        pw.write("css/fitnesse.css'/>");
    }

    protected void writeExtraHeaderContent(PrintWriter pw, List<TestReportHtml> htmls) {
        this.getChartWriter(pw).writeLoadScriptTag();
    }

    protected void writeFooter(PrintWriter pw, List<TestReportHtml> htmls) {
        this.writeChartScript(pw, htmls);
        pw.write("</body></html>");
    }

    protected void writeBody(PrintWriter pw, List<TestReportHtml> htmls) {
        this.writeOverviewSection(pw, htmls);
        this.writeTestResultsSection(pw, htmls);
    }

    protected void writeOverviewSection(PrintWriter pw, List<TestReportHtml> htmls) {
        this.writeOverviewGraph(pw, htmls);
        this.writeLinks(pw, htmls);
        List<TestReportHtml> overviewPages = HtmlOverviewFileWriter.filterBy(htmls, TestReportHtml::isOverviewPage);
        this.writeSection(pw, "Overview Pages", overviewPages);
    }

    protected void writeOverviewGraph(PrintWriter pw, List<TestReportHtml> htmls) {
        pw.write("<div style='width:100%;'>");
        List<TestReportHtml> testHtmls = HtmlOverviewFileWriter.filterBy(htmls, x -> !x.isOverviewPage() && !"no-test".equals(x.getStatus()));
        pw.write("<table style='width:100%;text-align:center;' id='simpleStatusGraph'><tr>");
        this.writeGraphCell(pw, "error", testHtmls);
        this.writeGraphCell(pw, "fail", testHtmls);
        this.writeGraphCell(pw, "ignore", testHtmls);
        this.writeGraphCell(pw, "pass", testHtmls);
        pw.write("</tr></table>");
        this.writePieChartsElement(pw, htmls);
        pw.write("</div>");
    }

    protected void writeGraphCell(PrintWriter pw, String status, List<TestReportHtml> testHtmls) {
        int totalCount = testHtmls.size();
        int count = HtmlOverviewFileWriter.filterByStatus(testHtmls, status).size();
        if (count > 0) {
            int pct = count * 100 / totalCount;
            String cell = String.format("<td class=\"%s\" style=\"width:%s%%;\">%s</td>", status, pct, count);
            pw.write(cell);
        }
    }

    protected void writePieChartsElement(PrintWriter pw, List<TestReportHtml> htmls) {
        pw.write("<div style='display:flex;flex-wrap:wrap;justify-content:center;'>");
        this.writePieChartElements(pw, htmls);
        pw.write("</div>");
    }

    protected void writeChartGeneratorBody(ChartWriter writer, List<TestReportHtml> htmls) {
        List<TestReportHtml> nonOverviews = HtmlOverviewFileWriter.filterBy(htmls, r -> !r.isOverviewPage());
        this.writeStatusPieChartGenerator(writer, nonOverviews);
        writer.writePieChartGenerator("Tests / Run", TESTCOUNT_CHART_ID, nonOverviews, r -> r.getRunName(), Collectors.counting());
        writer.writePieChartGenerator("Time / Run", RUNTIME_CHART_ID, nonOverviews, r -> r.getRunName(), Collectors.summingLong(r -> r.getTime() < 0L ? 0L : r.getTime()));
        writer.writeBarChartGenerator(pw -> this.jsonWriterFunction.apply((PrintWriter)pw).writeContent(htmls), "ms / Test", TIME_PER_TEST_CHART_ID, ",hAxis:{textPosition:'none'}");
    }

    protected void writeStatusPieChartGenerator(ChartWriter writer, List<TestReportHtml> htmls) {
        Map<String, Long> displayedStatus = this.getStatusMap(htmls);
        writer.writePieChartGenerator("Status", STATUS_CHART_ID, ",slices:[{color:'#ffffaa'},{color:'#FF6666'},{color:'orange'},{color:'#28B463'},{color:'lightgray'}]", r -> (String)r.getKey(), r -> (Long)r.getValue(), displayedStatus.entrySet());
    }

    protected void writePieChartElements(PrintWriter pw, List<TestReportHtml> htmls) {
        pw.write("<div id='");
        pw.write(STATUS_CHART_ID);
        pw.write("'></div>");
        pw.write("<div id='");
        pw.write(TESTCOUNT_CHART_ID);
        pw.write("'></div>");
        pw.write("<div id='");
        pw.write(RUNTIME_CHART_ID);
        pw.write("'></div>");
    }

    protected void writeLinks(PrintWriter pw, List<TestReportHtml> htmls) {
        pw.write("<div style='position:absolute;right:0;margin-right:2em;'>");
        pw.write("Test results in:&nbsp;");
        pw.write("<a href='test-results.csv'>CSV</a>&nbsp;<a href='test-results.json'>JSON</a>");
        pw.write("</div>");
    }

    protected void writeTestResultsSection(PrintWriter pw, List<TestReportHtml> htmls) {
        List<TestReportHtml> testHtmls = HtmlOverviewFileWriter.filterBy(htmls, x -> !x.isOverviewPage());
        pw.write("<div id='TestResults' style='width:100%;'>");
        List<TestReportHtml> erroredTests = HtmlOverviewFileWriter.filterByStatus(testHtmls, "error");
        this.writeSection(pw, "Errored Tests", erroredTests);
        List<TestReportHtml> failedTests = HtmlOverviewFileWriter.filterByStatus(testHtmls, "fail");
        this.writeSection(pw, "Failed Tests", failedTests);
        List<TestReportHtml> ignoredTests = HtmlOverviewFileWriter.filterByStatus(testHtmls, "ignore");
        this.writeSection(pw, "Ignored Tests", ignoredTests);
        pw.write("<div id='");
        pw.write(TIME_PER_TEST_CHART_ID);
        pw.write("' style='height: 300px;'></div>");
        List<TestReportHtml> passedTests = HtmlOverviewFileWriter.filterByStatus(testHtmls, "pass");
        this.writeSection(pw, "Passed Tests", passedTests);
        List<TestReportHtml> noTests = HtmlOverviewFileWriter.filterByStatus(testHtmls, "no-test");
        this.writeSection(pw, "Pages Without Assertions", noTests);
        pw.write("</div>");
    }

    protected void writeSection(PrintWriter pw, String header, List<TestReportHtml> htmls) {
        if (!htmls.isEmpty()) {
            String id = header.replaceAll("\\s", "");
            pw.write("<div id=\"");
            pw.write(id);
            pw.write("\">");
            pw.write("<h2>");
            pw.write(header);
            pw.write("</h2>");
            String tableId = id + "Table";
            pw.write("<input type='button' value='to clipboard' ");
            pw.write("onclick=\"elementContentsToClipboard(document.getElementById('");
            pw.write(tableId);
            pw.write("'));\">");
            this.writeTestsTable(pw, tableId, htmls);
            pw.write("</div>");
        }
    }

    protected void writeTestsTable(PrintWriter pw, String id, List<TestReportHtml> htmls) {
        pw.write("<table id='");
        pw.write(id);
        pw.write("'><tr><th>Run</th><th>Name</th><th>Runtime (in milliseconds)</th></tr>");
        htmls.sort((o1, o2) -> Long.compare(o2.getTime(), o1.getTime()));
        for (TestReportHtml test : htmls) {
            this.writeTestRow(pw, test);
        }
        pw.write("</table>");
    }

    protected void writeTestRow(PrintWriter pw, TestReportHtml html) {
        String testPageName = html.getRelativePath();
        String status = html.getStatus();
        String run = html.getRunName();
        String testName = html.getTestName();
        long time = html.getTime();
        pw.write("<tr class=\"");
        pw.write(status);
        pw.write("\">");
        pw.write("<td>");
        pw.write(run);
        pw.write("</td>");
        pw.write("<td><a href=\"");
        pw.write(testPageName);
        pw.write("\">");
        pw.write(testName);
        pw.write("</a></td><td>");
        pw.write(time < 0L ? "unknown" : this.nf.format(time));
        pw.write("</td></tr>");
    }

    protected Map<String, Long> getStatusMap(List<TestReportHtml> htmls) {
        Map<String, Long> statuses = htmls.stream().collect(Collectors.groupingBy(TestReportHtml::getStatus, Collectors.counting()));
        LinkedHashMap<String, Long> displayedStatus = new LinkedHashMap<String, Long>();
        this.addStatusEntry("error", statuses, displayedStatus);
        this.addStatusEntry("fail", statuses, displayedStatus);
        this.addStatusEntry("ignore", statuses, displayedStatus);
        this.addStatusEntry("pass", statuses, displayedStatus);
        this.addStatusEntry("no-test", statuses, displayedStatus);
        return displayedStatus;
    }

    protected void addStatusEntry(String status, Map<String, Long> statuses, Map<String, Long> displayedStatus) {
        displayedStatus.put(status, statuses.getOrDefault(status, 0L));
    }

    protected void writeChartScript(PrintWriter pw, List<TestReportHtml> htmls) {
        ChartWriter chartWriter = this.getChartWriter(pw);
        chartWriter.writeChartGenerators(htmls, this::writeChartGeneratorBody, "document.getElementById('simpleStatusGraph').outerHTML=''", TIME_PER_TEST_CHART_ID);
    }

    protected ChartWriter getChartWriter(PrintWriter pw) {
        return new ChartWriter(pw);
    }

    protected static List<TestReportHtml> filterByStatus(List<TestReportHtml> htmls, String desiredStatus) {
        return HtmlOverviewFileWriter.filterBy(htmls, x -> desiredStatus.equals(x.getStatus()));
    }

    protected static <T> List<T> filterBy(List<T> list, Predicate<T> predicate) {
        return list.stream().filter(predicate).collect(Collectors.toList());
    }
}

