/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.reportmerge.writer;

import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import nl.hsac.fitnesse.junit.reportmerge.TestReportHtml;

public class JsonWriter {
    protected PrintWriter pw;

    public JsonWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public void writeContent(List<TestReportHtml> reports) {
        boolean first = true;
        this.pw.write("[");
        for (TestReportHtml report : reports) {
            if (first) {
                first = false;
            } else {
                this.pw.write(",");
            }
            this.writeReport(report);
        }
        this.pw.write("]");
    }

    protected void writeReport(TestReportHtml report) {
        this.pw.write("{");
        this.write("timestamp", report.getTimestamp());
        this.pw.write(",");
        this.write("runName", report.getRunName());
        this.pw.write(",");
        this.write("index", report.getIndex());
        this.pw.write(",");
        this.write("testName", report.getTestName());
        this.pw.write(",");
        this.write("status", report.getStatus());
        this.pw.write(",");
        this.write("time", report.getTime());
        this.pw.write(",");
        this.write("overviewPage", report.isOverviewPage());
        this.pw.write(",");
        this.write("relativePath", report.getRelativePath());
        this.pw.write("}");
    }

    protected void write(String key, String value) {
        this.writeKeyValue(key, "\"" + value + "\"");
    }

    protected void write(String key, boolean value) {
        this.writeKeyValue(key, value ? "true" : "false");
    }

    protected void write(String key, int value) {
        this.writeKeyValue(key, Integer.toString(value));
    }

    protected void write(String key, Date value) {
        this.write(key, value.getTime());
    }

    protected void write(String key, Long value) {
        this.writeKeyValue(key, Long.toString(value));
    }

    protected void writeKeyValue(String key, String value) {
        this.pw.write("\"");
        this.pw.write(key);
        this.pw.write("\":");
        this.pw.write(value);
    }
}

