/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.reportmerge.writer;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import nl.hsac.fitnesse.junit.reportmerge.TestReportHtml;

public abstract class OverviewFileWriter {
    private final File file;
    protected PrintWriter pw;

    public OverviewFileWriter(File parentDir, String name) {
        this.file = new File(parentDir, name);
    }

    public String write(List<TestReportHtml> reports) throws IOException {
        this.pw = new PrintWriter(this.file, StandardCharsets.UTF_8.name());
        try {
            this.writeContent(reports);
        }
        finally {
            if (this.pw != null) {
                this.pw.flush();
                this.pw.close();
            }
        }
        return this.file.getAbsolutePath();
    }

    protected abstract void writeContent(List<TestReportHtml> var1) throws IOException;
}

