/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.selenium;

import java.util.Map;
import nl.hsac.fitnesse.fixture.Environment;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.DriverFactory;
import nl.hsac.fitnesse.junit.selenium.SeleniumDriverFactoryFactory;
import org.apache.commons.lang3.StringUtils;

public abstract class SeleniumDriverFactoryFactoryBase
implements SeleniumDriverFactoryFactory {
    public static final String SELENIUM_GRID_URL = "seleniumGridUrl";
    public static final String SELENIUM_BROWSER = "seleniumBrowser";
    public static final String SELENIUM_DRIVER_CLASS = "seleniumDriverClass";
    public static final String SELENIUM_CAPABILITIES = "seleniumCapabilities";
    public static final String SELENIUM_JSONCAPABILITIES = "seleniumJsonCapabilities";
    public static final String SELENIUM_JSONPROFILE = "seleniumJsonProfile";

    @Override
    public abstract boolean willOverride();

    @Override
    public abstract DriverFactory getDriverFactory();

    protected boolean isPropertySet(String propertyName) {
        String value = this.getProperty(propertyName);
        return !StringUtils.isEmpty((CharSequence)value);
    }

    protected String getProperty(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected Map<String, Object> parseJsonProperty(String propertyName) {
        String capabilitiesString = this.getProperty(propertyName);
        try {
            return Environment.getInstance().getJsonHelper().jsonStringToMap(capabilitiesString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse value of JSON property: " + propertyName + ". Value was: " + capabilitiesString, e);
        }
    }
}

