/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.junit.selenium;

import java.net.URL;
import java.util.Map;
import java.util.function.BiFunction;
import nl.hsac.fitnesse.fixture.util.LambdaMetaHelper;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.DriverFactory;
import nl.hsac.fitnesse.fixture.util.selenium.driverfactory.RemoteDriverFactory;
import nl.hsac.fitnesse.junit.selenium.SeleniumDriverFactoryFactoryBase;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

public abstract class SeleniumGridWithCapabilitiesDriverFactoryFactoryBase
extends SeleniumDriverFactoryFactoryBase {
    private BiFunction<URL, Capabilities, RemoteWebDriver> webDriverConstructor;

    @Override
    public DriverFactory getDriverFactory() {
        String gridUrl = this.getProperty("seleniumGridUrl");
        Map<String, Object> capabilities = this.getCapabilities();
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities(capabilities);
        BiFunction<URL, Capabilities, RemoteWebDriver> constr = this.getRemoteWebDriverConstructor();
        return new RemoteDriverFactory<RemoteWebDriver>(constr, gridUrl, (Capabilities)desiredCapabilities);
    }

    protected BiFunction<URL, Capabilities, RemoteWebDriver> getRemoteWebDriverConstructor() {
        if (this.webDriverConstructor == null) {
            if (this.isPropertySet("seleniumDriverClass")) {
                String driverClass = this.getProperty("seleniumDriverClass");
                try {
                    Class<?> clazz = Class.forName(driverClass);
                    if (!RemoteWebDriver.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException(driverClass + " does not implement RemoteWebDiver");
                    }
                    Class<?> rmd = clazz;
                    this.webDriverConstructor = new LambdaMetaHelper().getConstructor(rmd, URL.class, Capabilities.class);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to create RemoteWebDriver using: " + driverClass, e);
                }
            } else {
                this.webDriverConstructor = RemoteWebDriver::new;
            }
        }
        return this.webDriverConstructor;
    }

    protected void setWebDriverConstructor(BiFunction<URL, Capabilities, RemoteWebDriver> constructor) {
        this.webDriverConstructor = constructor;
    }

    protected abstract Map<String, Object> getCapabilities();
}

