/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.slim.converter;

import fitnesse.slim.Converter;
import fitnesse.slim.converters.ConverterRegistry;
import fitnesse.slim.converters.ElementConverterHelper;
import fitnesse.slim.converters.GenericCollectionConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.hsac.fitnesse.slim.converter.ObjectConverter;

public class NumberedListConverter
extends GenericCollectionConverter<Object, List<Object>> {
    private static final Pattern LIST_PATTERN = Pattern.compile("<ol( start=\"\\d+\")?\\s*>\\s*((<li>\\s*.*?\\s*</li>\\s*)*)</ol>", 32);
    private static final Converter<Object> OBJ_CONVERTER = new ObjectConverter();

    public static void register() {
        try {
            Class<?> listObjectClass = NumberedListConverter.class.getMethod("getString", List.class).getParameterTypes()[0];
            NumberedListConverter converter = new NumberedListConverter();
            ConverterRegistry.addConverter(listObjectClass, (Converter)converter);
            ConverterRegistry.addConverter(ArrayList.class, (Converter)new NumberedArrayListConverter(converter));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NumberedListConverter() {
        super(ArrayList.class, OBJ_CONVERTER);
    }

    public String getString(List<Object> list) {
        StringBuilder messageList = new StringBuilder("<ol start=\"0\">");
        for (Object element : list) {
            messageList.append("<li>");
            String formattedElement = ElementConverterHelper.elementToString((Object)element);
            messageList.append(formattedElement);
            messageList.append("</li>");
        }
        messageList.append("</ol>");
        return messageList.toString();
    }

    public ArrayList<Object> getObject(String arg) {
        ArrayList<Object> result;
        Matcher matcher = LIST_PATTERN.matcher(arg);
        if (matcher.matches()) {
            result = new ArrayList<Object>();
            String items = matcher.group(2);
            if (!"".equals(items)) {
                items = items.replaceFirst("^\\s*<li>\\s*", "");
                items = items.replaceFirst("\\s*</li>\\s*$", "");
                String[] elements = items.split("\\s*</li>\\s*<li>\\s*");
                result.addAll(Arrays.asList(elements));
            }
        } else {
            result = new ArrayList(super.getObject(arg));
        }
        return result;
    }

    public static class NumberedArrayListConverter
    implements Converter<ArrayList> {
        private final NumberedListConverter numberedListConverter;

        public NumberedArrayListConverter(NumberedListConverter aNumberedListConverter) {
            this.numberedListConverter = aNumberedListConverter;
        }

        public String toString(ArrayList o) {
            return this.numberedListConverter.toString(o);
        }

        public ArrayList fromString(String arg) {
            return (ArrayList)this.numberedListConverter.fromString(arg);
        }
    }
}

