/*
 * Decompiled with CFR 0.152.
 */
package nl.hsac.fitnesse.slim.interaction;

import fitnesse.slim.fixtureInteraction.DefaultInteraction;
import fitnesse.slim.fixtureInteraction.FixtureInteraction;
import fitnesse.slim.fixtureInteraction.InteractionAwareFixture;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class FixtureFactory {
    private static final Map<Class<? extends InteractionAwareFixture>, Factory> FACTORIES = new HashMap<Class<? extends InteractionAwareFixture>, Factory>();
    private FixtureInteraction interaction = null;

    public FixtureInteraction getInteraction() {
        if (this.interaction == null) {
            this.interaction = new DefaultInteraction();
        }
        return this.interaction;
    }

    public void setInteraction(FixtureInteraction interaction) {
        this.interaction = interaction;
    }

    public <T extends InteractionAwareFixture> T create(Class<T> clazz) {
        return this.create(clazz, (Class<?>[])null, (Object[])null);
    }

    public <T extends InteractionAwareFixture> T create(Class<T> clazz, int constructorArg) {
        return this.create(clazz, new Class[]{Integer.TYPE}, new Object[]{constructorArg});
    }

    public <T extends InteractionAwareFixture> T create(Class<T> clazz, long constructorArg) {
        return this.create(clazz, new Class[]{Long.TYPE}, new Object[]{constructorArg});
    }

    public <T extends InteractionAwareFixture> T create(Class<T> clazz, double constructorArg) {
        return this.create(clazz, new Class[]{Double.TYPE}, new Object[]{constructorArg});
    }

    public <T extends InteractionAwareFixture> T create(Class<T> clazz, boolean constructorArg) {
        return this.create(clazz, new Class[]{Boolean.TYPE}, new Object[]{constructorArg});
    }

    public <T extends InteractionAwareFixture> T create(Class<T> clazz, Object ... constructorArgs) {
        T result;
        if (constructorArgs != null && constructorArgs.length > 0) {
            Class[] types = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                types[i] = constructorArgs[i].getClass();
            }
            result = this.create(clazz, types, constructorArgs);
        } else {
            result = this.create(clazz, (Class<?>[])null, (Object[])null);
        }
        return result;
    }

    public <T extends InteractionAwareFixture> T create(Class<T> clazz, Class<?>[] constructorTypes, Object[] constructorArgs) {
        T result;
        MethodInterceptor callback = this.createCallback();
        if (FACTORIES.containsKey(clazz)) {
            Factory factory = FACTORIES.get(clazz);
            result = this.createUsingFactory((Callback)callback, factory, constructorTypes, constructorArgs);
        } else {
            result = this.createFirst((Callback)callback, clazz, constructorTypes, constructorArgs);
            FACTORIES.put(clazz, (Factory)result);
        }
        return result;
    }

    protected <T extends InteractionAwareFixture> T createUsingFactory(Callback callback, Factory factory, Class<?>[] constructorTypes, Object[] constructorArgs) {
        Callback[] callbacks = new Callback[]{callback};
        InteractionAwareFixture result = constructorArgs != null && constructorArgs.length > 0 ? (InteractionAwareFixture)factory.newInstance((Class[])constructorTypes, constructorArgs, callbacks) : (InteractionAwareFixture)factory.newInstance(callbacks);
        return (T)result;
    }

    protected <T extends InteractionAwareFixture> T createFirst(Callback callback, Class<T> clazz, Class<?>[] constructorTypes, Object[] constructorArgs) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setCallback(callback);
        InteractionAwareFixture result = constructorArgs != null && constructorArgs.length > 0 ? (InteractionAwareFixture)enhancer.create((Class[])constructorTypes, constructorArgs) : (InteractionAwareFixture)enhancer.create();
        return (T)result;
    }

    protected MethodInterceptor createCallback() {
        FixtureInteraction nestedInteraction = this.getInteraction();
        return new LikeSlimInteraction(nestedInteraction);
    }

    protected static class LikeSlimInteraction
    implements MethodInterceptor {
        private final FixtureInteraction interaction;
        private boolean aroundInvoked = false;

        public LikeSlimInteraction(FixtureInteraction fixtureInteraction) {
            this.interaction = fixtureInteraction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (!this.aroundInvoked && Modifier.isPublic(method.getModifiers()) && !method.getDeclaringClass().equals(Object.class) && !"aroundSlimInvoke".equals(method.getName())) {
                this.aroundInvoked = true;
                try {
                    Object object = ((InteractionAwareFixture)obj).aroundSlimInvoke(this.interaction, method, args);
                    return object;
                }
                finally {
                    this.aroundInvoked = false;
                }
            }
            return proxy.invokeSuper(obj, args);
        }
    }
}

